---------------------------------------------------------------------------------------------------------------------------------
--Work Item 618144 Confirm non system (CRS) registries can be deleted
---------------------------------------------------------------------------------------------------------------------------------

/****** Object:  StoredProcedure [CRS].[usp_STD_REGISTRY_delete]    Script Date: 12/8/2017 9:39:48 AM ******/
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[CRS].[usp_STD_REGISTRY_delete]') AND type in (N'P', N'PC'))
DROP PROCEDURE [CRS].[usp_STD_REGISTRY_delete]
GO

/****** Object:  StoredProcedure [CRS].[usp_STD_REGISTRY_delete]    Script Date: 12/8/2017 9:39:48 AM ******/
SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[CRS].[usp_STD_REGISTRY_delete]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'

-- =============================================
-- Author:        
-- Create date:   12/02/2015
-- Description:   Delete record by ID
-- =============================================
CREATE PROCEDURE [CRS].[usp_STD_REGISTRY_delete] (@CURRENT_USER varchar(30), @CURRENT_REGISTRY_ID int, @ID int)
AS
BEGIN
	-- SET NOCOUNT ON added to prevent extra result sets from
	-- interfering with SELECT statements.
	SET NOCOUNT ON;

	DECLARE @CoreRegistryCode VARCHAR(50) = ''CRS'';
	DECLARE @ErrorMsg varchar(max);

	IF ([CRS].[ValidateUserRole](@CURRENT_USER, 0, ''CRSADMIN,REGADMIN'') = 0)
	BEGIN
		SET @ErrorMsg = ''User is not authorized to perform this action.'';
		EXEC [CRS].[InsDBLog] @CURRENT_REGISTRY_ID, 0, ''CRS.usp_STD_REGISTRY_delete'', @ErrorMsg, ''User is not part of an Admin Role'', @CURRENT_USER
		SELECT @ErrorMsg as [ErrorMsg];
		RETURN
	END

	DECLARE @Code VARCHAR(50)
	IF (SELECT Code FROM CRS.STD_REGISTRY WHERE ID = @ID) = @CoreRegistryCode
	BEGIN
		SET @ErrorMsg = ''This registry cannot be deleted.'';
		SELECT @ErrorMsg as [ErrorMsg];
		RETURN
	END

	DECLARE @OldValues varchar(max);
	SELECT @OldValues = ''<CODE>'' + ISNULL(CAST([CODE] AS varchar), '''') + ''</CODE><COMMENTS>'' + ISNULL(CAST([COMMENTS] AS varchar), '''') + ''</COMMENTS><CREATED>'' + ISNULL(CAST([CREATED] AS varchar), '''') + ''</CREATED><CREATEDBY>'' + ISNULL(CAST([CREATEDBY] AS varchar), '''') + ''</CREATEDBY><DESCRIPTION_TEXT>'' + ISNULL(CAST([DESCRIPTION_TEXT] AS varchar), '''') + ''</DESCRIPTION_TEXT><ID>'' + ISNULL(CAST([ID] AS varchar), '''') + ''</ID><INACTIVE_DATE>'' + ISNULL(CAST([INACTIVE_DATE] AS varchar), '''') + ''</INACTIVE_DATE><INACTIVE_FLAG>'' + ISNULL(CAST([INACTIVE_FLAG] AS varchar), '''') + ''</INACTIVE_FLAG><NAME>'' + ISNULL(CAST([NAME] AS varchar), '''') + ''</NAME><REGISTRY_ADMINISTRATOR>'' + ISNULL(CAST([REGISTRY_ADMINISTRATOR] AS varchar), '''') + ''</REGISTRY_ADMINISTRATOR><REGISTRY_OWNER>'' + ISNULL(CAST([REGISTRY_OWNER] AS varchar), '''') + ''</REGISTRY_OWNER><REGISTRY_SUPPORT_CONTACT>'' + ISNULL(CAST([REGISTRY_SUPPORT_CONTACT] AS varchar), '''') + ''</REGISTRY_SUPPORT_CONTACT><SORT_ORDER>'' + ISNULL(CAST([SORT_ORDER] AS varchar), '''') + ''</SORT_ORDER><UPDATED>'' + ISNULL(CAST([UPDATED] AS varchar), '''') + ''</UPDATED><UPDATEDBY>'' + ISNULL(CAST([UPDATEDBY] AS varchar), '''') + ''</UPDATEDBY>'' FROM [CRS].[STD_REGISTRY] WHERE [ID] = @ID;
	SELECT @ErrorMsg = ''[CRS].[STD_REGISTRY] values deleted (Old Values:'' + @OldValues + '' ) by ('' + @CURRENT_USER + '')'';
	EXEC [CRS].[InsDBLog] @CURRENT_REGISTRY_ID, 0, ''CRS.usp_STD_REGISTRY_delete'', @ErrorMsg, NULL, @CURRENT_USER;

	UPDATE [CRS].[STD_REGISTRY] SET [INACTIVE_FLAG] = 1 WHERE [ID] = @ID;
END' 

END
GO

---------------------------------------------------------------------------------------------------------------------------------
--Work Item 618266 Add Comment text area and/or functionality to all survey fields
---------------------------------------------------------------------------------------------------------------------------------

/****** Object:  Table [CRS].[SURVEY_RESULTS]    Script Date: 12/8/2017 9:54:29 AM ******/
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[CRS].[SURVEY_RESULTS]') AND type in (N'U'))
BEGIN
	IF NOT EXISTS (SELECT * FROM sys.columns WHERE object_id = OBJECT_ID(N'[CRS].[SURVEY_RESULTS]') AND name in (N'COMMENTS_TEXT'))
	BEGIN
		ALTER TABLE CRS.SURVEY_RESULTS ADD COMMENTS_TEXT VARCHAR(MAX) NULL;
	END
END
GO

/****** Object:  StoredProcedure [CRS].[usp_SURVEY_RESULTS_save]    Script Date: 12/8/2017 10:01:48 AM ******/
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[CRS].[usp_SURVEY_RESULTS_save]') AND type in (N'P', N'PC'))
DROP PROCEDURE [CRS].[usp_SURVEY_RESULTS_save]
GO

/****** Object:  StoredProcedure [CRS].[usp_SURVEY_RESULTS_save]    Script Date: 12/8/2017 10:01:48 AM ******/
SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[CRS].[usp_SURVEY_RESULTS_save]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'
-- =============================================
-- Author:        
-- Create date:   05/06/2016
-- Description:   Save/Update a record
-- =============================================
CREATE PROCEDURE [CRS].[usp_SURVEY_RESULTS_save] (@CURRENT_USER varchar(30), @CURRENT_REGISTRY_ID int, @CREATED datetime, @CREATEDBY varchar(30), @RESULT_TEXT varchar(max), @SELECTED_FLAG bit, @STD_QUESTION_CHOICE_ID int, @STD_QUESTION_ID int, @SURVEY_RESULT_ID int output, @SURVEYS_ID int, @UPDATED datetime, @UPDATEDBY varchar(30),@COMMENTS_TEXT varchar(max))
AS
BEGIN
	-- SET NOCOUNT ON added to prevent extra result sets from
	-- interfering with SELECT statements.
	SET NOCOUNT ON;

	DECLARE @ErrorMsg varchar(max);

	IF ([CRS].[ValidateUser](@CURRENT_USER, @CURRENT_REGISTRY_ID) = 0)
	BEGIN
		SET @ErrorMsg = ''User is not authorized to perform this action.'';
		EXEC [CRS].[InsDBLog] @CURRENT_REGISTRY_ID, 0, ''CRS.usp_SURVEY_RESULTS_save'', @ErrorMsg, ''User is not part of this Registry'', @CURRENT_USER
		SELECT @ErrorMsg as [ErrorMsg];
		RETURN
	END

	SET @CREATED = GetDate();
	SET @UPDATED = GetDate();
	SET @CREATEDBY = @CURRENT_USER;
	SET @UPDATEDBY = @CURRENT_USER;

	IF ISNULL(@SURVEY_RESULT_ID,0) = 0
		BEGIN
			INSERT INTO [CRS].[SURVEY_RESULTS] ([CREATED], [CREATEDBY], [RESULT_TEXT],[SELECTED_FLAG], [STD_QUESTION_CHOICE_ID], [STD_QUESTION_ID], [SURVEYS_ID], [UPDATED], [UPDATEDBY], [COMMENTS_TEXT] )
			VALUES (@CREATED, @CREATEDBY, @RESULT_TEXT, @SELECTED_FLAG, @STD_QUESTION_CHOICE_ID, @STD_QUESTION_ID, @SURVEYS_ID, @UPDATED, @UPDATEDBY, @COMMENTS_TEXT);
			SELECT @SURVEY_RESULT_ID = SCOPE_IDENTITY();
		END
	ELSE
		BEGIN
			DECLARE @OldValues varchar(max), @NewValues varchar(max);
			SELECT @OldValues = ''<CREATED>'' + ISNULL(CAST([CREATED] AS varchar), '''') + ''</CREATED><CREATEDBY>'' + ISNULL(CAST([CREATEDBY] AS varchar), '''') + ''</CREATEDBY><RESULT_TEXT>'' + ISNULL(CAST([RESULT_TEXT] AS varchar), '''') + ''</RESULT_TEXT><SELECTED_FLAG>'' + ISNULL(CAST([SELECTED_FLAG] AS varchar), '''') + ''</SELECTED_FLAG><STD_QUESTION_CHOICE_ID>'' + ISNULL(CAST([STD_QUESTION_CHOICE_ID] AS varchar), '''') + ''</STD_QUESTION_CHOICE_ID><STD_QUESTION_ID>'' + ISNULL(CAST([STD_QUESTION_ID] AS varchar), '''') + ''</STD_QUESTION_ID><SURVEY_RESULT_ID>'' + ISNULL(CAST([SURVEY_RESULT_ID] AS varchar), '''') + ''</SURVEY_RESULT_ID><SURVEYS_ID>'' + ISNULL(CAST([SURVEYS_ID] AS varchar), '''') + ''</SURVEYS_ID><UPDATED>'' + ISNULL(CAST([UPDATED] AS varchar), '''') + ''</UPDATED><UPDATEDBY>'' + ISNULL(CAST([UPDATEDBY] AS varchar), '''') + ''</UPDATEDBY>'' FROM [CRS].[SURVEY_RESULTS] WHERE [SURVEY_RESULT_ID] = @SURVEY_RESULT_ID;
			SELECT @NewValues = ''<CREATED>'' + ISNULL(CAST(@CREATED AS varchar), '''') + ''</CREATED><CREATEDBY>'' + ISNULL(CAST(@CREATEDBY AS varchar), '''') + ''</CREATEDBY><RESULT_TEXT>'' + ISNULL(CAST(@RESULT_TEXT AS varchar), '''') + ''</RESULT_TEXT><SELECTED_FLAG>'' + ISNULL(CAST(@SELECTED_FLAG AS varchar), '''') + ''</SELECTED_FLAG><STD_QUESTION_CHOICE_ID>'' + ISNULL(CAST(@STD_QUESTION_CHOICE_ID AS varchar), '''') + ''</STD_QUESTION_CHOICE_ID><STD_QUESTION_ID>'' + ISNULL(CAST(@STD_QUESTION_ID AS varchar), '''') + ''</STD_QUESTION_ID><SURVEY_RESULT_ID>'' + ISNULL(CAST(@SURVEY_RESULT_ID AS varchar), '''') + ''</SURVEY_RESULT_ID><SURVEYS_ID>'' + ISNULL(CAST(@SURVEYS_ID AS varchar), '''') + ''</SURVEYS_ID><UPDATED>'' + ISNULL(CAST(@UPDATED AS varchar), '''') + ''</UPDATED><UPDATEDBY>'' + ISNULL(CAST(@UPDATEDBY AS varchar), '''') + ''</UPDATEDBY>'';
			SELECT @ErrorMsg = ''[CRS].[SURVEY_RESULTS] values have been updated (Old Values:'' + @OldValues + '') to (New Values:'' + @NewValues + '') by ('' + @CURRENT_USER + '')'';
			EXEC [CRS].[InsDBLog] @CURRENT_REGISTRY_ID, 0, ''CRS.usp_SURVEY_RESULTS_save'', @ErrorMsg, NULL, @CURRENT_USER;

			UPDATE [CRS].[SURVEY_RESULTS] 
			SET
				[RESULT_TEXT] = @RESULT_TEXT
				, [SELECTED_FLAG] = @SELECTED_FLAG
				, [STD_QUESTION_CHOICE_ID] = @STD_QUESTION_CHOICE_ID
				, [STD_QUESTION_ID] = @STD_QUESTION_ID
				, [SURVEYS_ID] = @SURVEYS_ID
				, [UPDATED] = @UPDATED
				, [UPDATEDBY] = @UPDATEDBY
				, [COMMENTS_TEXT]=@COMMENTS_TEXT
			WHERE
				[SURVEY_RESULT_ID] = @SURVEY_RESULT_ID;
		END
END' 

END
GO


---------------------------------------------------------------------------------------------------------------------------------
--Work Item 618249 Add Functionality to display Framework data details
---------------------------------------------------------------------------------------------------------------------------------

/****** Object:  StoredProcedure [CRS].[usp_VITALSIGN_getitemsByReferral]    Script Date: 12/8/2017 10:07:52 AM ******/
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[CRS].[usp_VITALSIGN_getitemsByReferral]') AND type in (N'P', N'PC'))
DROP PROCEDURE [CRS].[usp_VITALSIGN_getitemsByReferral]
GO

/****** Object:  StoredProcedure [CRS].[usp_TIU_TIUDOCUMENT_getitemsByReferral]    Script Date: 12/8/2017 10:07:52 AM ******/
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[CRS].[usp_TIU_TIUDOCUMENT_getitemsByReferral]') AND type in (N'P', N'PC'))
DROP PROCEDURE [CRS].[usp_TIU_TIUDOCUMENT_getitemsByReferral]
GO

/****** Object:  StoredProcedure [CRS].[usp_SPATIENT_SPATIENTINSURANCE_getitemsByReferral]    Script Date: 12/8/2017 10:07:52 AM ******/
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[CRS].[usp_SPATIENT_SPATIENTINSURANCE_getitemsByReferral]') AND type in (N'P', N'PC'))
DROP PROCEDURE [CRS].[usp_SPATIENT_SPATIENTINSURANCE_getitemsByReferral]
GO

/****** Object:  StoredProcedure [CRS].[usp_SPATIENT_NEW_getitemsByReferral]    Script Date: 12/8/2017 10:07:52 AM ******/
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[CRS].[usp_SPATIENT_NEW_getitemsByReferral]') AND type in (N'P', N'PC'))
DROP PROCEDURE [CRS].[usp_SPATIENT_NEW_getitemsByReferral]
GO

/****** Object:  StoredProcedure [CRS].[usp_SERVICE_CONNECTED_CONDITION_getitemsByReferral]    Script Date: 12/8/2017 10:07:52 AM ******/
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[CRS].[usp_SERVICE_CONNECTED_CONDITION_getitemsByReferral]') AND type in (N'P', N'PC'))
DROP PROCEDURE [CRS].[usp_SERVICE_CONNECTED_CONDITION_getitemsByReferral]
GO

/****** Object:  StoredProcedure [CRS].[usp_SCONSULT_REASON_getitemsByReferral]    Script Date: 12/8/2017 10:07:52 AM ******/
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[CRS].[usp_SCONSULT_REASON_getitemsByReferral]') AND type in (N'P', N'PC'))
DROP PROCEDURE [CRS].[usp_SCONSULT_REASON_getitemsByReferral]
GO

/****** Object:  StoredProcedure [CRS].[usp_RXOUTPAT_getitemsByReferral]    Script Date: 12/8/2017 10:07:52 AM ******/
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[CRS].[usp_RXOUTPAT_getitemsByReferral]') AND type in (N'P', N'PC'))
DROP PROCEDURE [CRS].[usp_RXOUTPAT_getitemsByReferral]
GO

/****** Object:  StoredProcedure [CRS].[usp_RADIOLOGYEXAM_getitemsByReferral]    Script Date: 12/8/2017 10:07:52 AM ******/
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[CRS].[usp_RADIOLOGYEXAM_getitemsByReferral]') AND type in (N'P', N'PC'))
DROP PROCEDURE [CRS].[usp_RADIOLOGYEXAM_getitemsByReferral]
GO

/****** Object:  StoredProcedure [CRS].[usp_PHARMACY_PATIENT_getitemsByReferral]    Script Date: 12/8/2017 10:07:52 AM ******/
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[CRS].[usp_PHARMACY_PATIENT_getitemsByReferral]') AND type in (N'P', N'PC'))
DROP PROCEDURE [CRS].[usp_PHARMACY_PATIENT_getitemsByReferral]
GO

/****** Object:  StoredProcedure [CRS].[usp_PATSUB_VARATEDDISABILITY_getitemsByReferral]    Script Date: 12/8/2017 10:07:52 AM ******/
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[CRS].[usp_PATSUB_VARATEDDISABILITY_getitemsByReferral]') AND type in (N'P', N'PC'))
DROP PROCEDURE [CRS].[usp_PATSUB_VARATEDDISABILITY_getitemsByReferral]
GO

/****** Object:  StoredProcedure [CRS].[usp_PATSUB_SECONDARYELIGIBILITY_getitemsByReferral]    Script Date: 12/8/2017 10:07:52 AM ******/
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[CRS].[usp_PATSUB_SECONDARYELIGIBILITY_getitemsByReferral]') AND type in (N'P', N'PC'))
DROP PROCEDURE [CRS].[usp_PATSUB_SECONDARYELIGIBILITY_getitemsByReferral]
GO

/****** Object:  StoredProcedure [CRS].[usp_PATIENT_ETHNICITY_getitemsByReferral]    Script Date: 12/8/2017 10:07:52 AM ******/
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[CRS].[usp_PATIENT_ETHNICITY_getitemsByReferral]') AND type in (N'P', N'PC'))
DROP PROCEDURE [CRS].[usp_PATIENT_ETHNICITY_getitemsByReferral]
GO

/****** Object:  StoredProcedure [CRS].[usp_PATIENT_ENROLLMENT_getitemsByReferral]    Script Date: 12/8/2017 10:07:52 AM ******/
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[CRS].[usp_PATIENT_ENROLLMENT_getitemsByReferral]') AND type in (N'P', N'PC'))
DROP PROCEDURE [CRS].[usp_PATIENT_ENROLLMENT_getitemsByReferral]
GO

/****** Object:  StoredProcedure [CRS].[usp_OUTPAT_VDIAGNOSIS_getitemsByReferral]    Script Date: 12/8/2017 10:07:52 AM ******/
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[CRS].[usp_OUTPAT_VDIAGNOSIS_getitemsByReferral]') AND type in (N'P', N'PC'))
DROP PROCEDURE [CRS].[usp_OUTPAT_VDIAGNOSIS_getitemsByReferral]
GO

/****** Object:  StoredProcedure [CRS].[usp_OUTPAT_PROBLEMLIST_getitemsByReferral]    Script Date: 12/8/2017 10:07:52 AM ******/
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[CRS].[usp_OUTPAT_PROBLEMLIST_getitemsByReferral]') AND type in (N'P', N'PC'))
DROP PROCEDURE [CRS].[usp_OUTPAT_PROBLEMLIST_getitemsByReferral]
GO

/****** Object:  StoredProcedure [CRS].[usp_OEFOIF_SERVICE_getitemsByReferral]    Script Date: 12/8/2017 10:07:52 AM ******/
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[CRS].[usp_OEFOIF_SERVICE_getitemsByReferral]') AND type in (N'P', N'PC'))
DROP PROCEDURE [CRS].[usp_OEFOIF_SERVICE_getitemsByReferral]
GO

/****** Object:  StoredProcedure [CRS].[usp_NOSETHROAT_RADIUMHST_getitemsByReferral]    Script Date: 12/8/2017 10:07:52 AM ******/
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[CRS].[usp_NOSETHROAT_RADIUMHST_getitemsByReferral]') AND type in (N'P', N'PC'))
DROP PROCEDURE [CRS].[usp_NOSETHROAT_RADIUMHST_getitemsByReferral]
GO

/****** Object:  StoredProcedure [CRS].[usp_MILITARY_SEXUAL_TRAUMA_getitemsByReferral]    Script Date: 12/8/2017 10:07:52 AM ******/
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[CRS].[usp_MILITARY_SEXUAL_TRAUMA_getitemsByReferral]') AND type in (N'P', N'PC'))
DROP PROCEDURE [CRS].[usp_MILITARY_SEXUAL_TRAUMA_getitemsByReferral]
GO

/****** Object:  StoredProcedure [CRS].[usp_MILITARY_SERVICE_EPISODE_getitemsByReferral]    Script Date: 12/8/2017 10:07:52 AM ******/
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[CRS].[usp_MILITARY_SERVICE_EPISODE_getitemsByReferral]') AND type in (N'P', N'PC'))
DROP PROCEDURE [CRS].[usp_MILITARY_SERVICE_EPISODE_getitemsByReferral]
GO

/****** Object:  StoredProcedure [CRS].[usp_INPATIENT_DIAGNOSIS_getitemsByReferral]    Script Date: 12/8/2017 10:07:52 AM ******/
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[CRS].[usp_INPATIENT_DIAGNOSIS_getitemsByReferral]') AND type in (N'P', N'PC'))
DROP PROCEDURE [CRS].[usp_INPATIENT_DIAGNOSIS_getitemsByReferral]
GO

/****** Object:  StoredProcedure [CRS].[usp_INPAT_INPATIENT_getitemsByReferral]    Script Date: 12/8/2017 10:07:52 AM ******/
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[CRS].[usp_INPAT_INPATIENT_getitemsByReferral]') AND type in (N'P', N'PC'))
DROP PROCEDURE [CRS].[usp_INPAT_INPATIENT_getitemsByReferral]
GO

/****** Object:  StoredProcedure [CRS].[usp_INPAT_CENSUS_getitemsByReferral]    Script Date: 12/8/2017 10:07:52 AM ******/
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[CRS].[usp_INPAT_CENSUS_getitemsByReferral]') AND type in (N'P', N'PC'))
DROP PROCEDURE [CRS].[usp_INPAT_CENSUS_getitemsByReferral]
GO

/****** Object:  StoredProcedure [CRS].[usp_Immunization_getitemsByReferral]    Script Date: 12/8/2017 10:07:52 AM ******/
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[CRS].[usp_Immunization_getitemsByReferral]') AND type in (N'P', N'PC'))
DROP PROCEDURE [CRS].[usp_Immunization_getitemsByReferral]
GO

/****** Object:  StoredProcedure [CRS].[usp_EDISLOG_getitemsByReferral]    Script Date: 12/8/2017 10:07:52 AM ******/
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[CRS].[usp_EDISLOG_getitemsByReferral]') AND type in (N'P', N'PC'))
DROP PROCEDURE [CRS].[usp_EDISLOG_getitemsByReferral]
GO

/****** Object:  StoredProcedure [CRS].[usp_Consult_getitemsByReferral]    Script Date: 12/8/2017 10:07:52 AM ******/
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[CRS].[usp_Consult_getitemsByReferral]') AND type in (N'P', N'PC'))
DROP PROCEDURE [CRS].[usp_Consult_getitemsByReferral]
GO

/****** Object:  StoredProcedure [CRS].[usp_CHEM_LABCHEM_getitemsByReferral]    Script Date: 12/8/2017 10:07:52 AM ******/
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[CRS].[usp_CHEM_LABCHEM_getitemsByReferral]') AND type in (N'P', N'PC'))
DROP PROCEDURE [CRS].[usp_CHEM_LABCHEM_getitemsByReferral]
GO

/****** Object:  StoredProcedure [CRS].[usp_ALLERGY_getitemsByReferral]    Script Date: 12/8/2017 10:07:52 AM ******/
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[CRS].[usp_ALLERGY_getitemsByReferral]') AND type in (N'P', N'PC'))
DROP PROCEDURE [CRS].[usp_ALLERGY_getitemsByReferral]
GO

/****** Object:  StoredProcedure [CRS].[usp_A06_SPATIENT_GEOCODEDADDRESS_getitemsByReferral]    Script Date: 12/8/2017 10:07:52 AM ******/
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[CRS].[usp_A06_SPATIENT_GEOCODEDADDRESS_getitemsByReferral]') AND type in (N'P', N'PC'))
DROP PROCEDURE [CRS].[usp_A06_SPATIENT_GEOCODEDADDRESS_getitemsByReferral]
GO

/****** Object:  StoredProcedure [CRS].[usp_A06_PHARMACY_PATX_NONVA_MEDS_55_05_getitemsByReferral]    Script Date: 12/8/2017 10:07:52 AM ******/
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[CRS].[usp_A06_PHARMACY_PATX_NONVA_MEDS_55_05_getitemsByReferral]') AND type in (N'P', N'PC'))
DROP PROCEDURE [CRS].[usp_A06_PHARMACY_PATX_NONVA_MEDS_55_05_getitemsByReferral]
GO

/****** Object:  StoredProcedure [CRS].[usp_A06_PHARMACY_PATIX_UNIT_DOSE_55_06_getitemsByReferral]    Script Date: 12/8/2017 10:07:52 AM ******/
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[CRS].[usp_A06_PHARMACY_PATIX_UNIT_DOSE_55_06_getitemsByReferral]') AND type in (N'P', N'PC'))
DROP PROCEDURE [CRS].[usp_A06_PHARMACY_PATIX_UNIT_DOSE_55_06_getitemsByReferral]
GO

/****** Object:  StoredProcedure [CRS].[usp_A06_PHARMACY_PATIENT_55X_IV_55_01_getitemsByReferral]    Script Date: 12/8/2017 10:07:52 AM ******/
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[CRS].[usp_A06_PHARMACY_PATIENT_55X_IV_55_01_getitemsByReferral]') AND type in (N'P', N'PC'))
DROP PROCEDURE [CRS].[usp_A06_PHARMACY_PATIENT_55X_IV_55_01_getitemsByReferral]
GO

/****** Object:  StoredProcedure [CRS].[usp_A06_AUDIOMETRIC_EXAM_DATA_509850_9_getitemsByReferral]    Script Date: 12/8/2017 10:07:52 AM ******/
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[CRS].[usp_A06_AUDIOMETRIC_EXAM_DATA_509850_9_getitemsByReferral]') AND type in (N'P', N'PC'))
DROP PROCEDURE [CRS].[usp_A06_AUDIOMETRIC_EXAM_DATA_509850_9_getitemsByReferral]
GO

/****** Object:  StoredProcedure [CRS].[usp_A06_AUDIOMETRIC_EXAM_DATA_509850_9_getitemsByReferral]    Script Date: 12/8/2017 10:07:52 AM ******/
SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[CRS].[usp_A06_AUDIOMETRIC_EXAM_DATA_509850_9_getitemsByReferral]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'
-- =============================================
-- Author:        
-- Create date:   12/6/2017
-- Description:   Get all A06_AUDIOMETRIC_EXAM_DATA_509850_9 records by Referral
-- =============================================
CREATE PROCEDURE [CRS].[usp_A06_AUDIOMETRIC_EXAM_DATA_509850_9_getitemsByReferral] (@CURRENT_USER varchar(30), @CURRENT_REGISTRY_ID int, @REFERRAL_ID int)
AS
BEGIN
	-- SET NOCOUNT ON added to prevent extra result sets from
	-- interfering with SELECT statements.
	SET NOCOUNT ON;

	DECLARE @ErrorMsg varchar(max);

	IF ([CRS].[ValidateUser](@CURRENT_USER, @CURRENT_REGISTRY_ID) = 0)
	BEGIN
		SET @ErrorMsg = ''User is not authorized to perform this action.'';
		EXEC [CRS].[InsDBLog] @CURRENT_REGISTRY_ID, 0, ''CRS.usp_A06_AUDIOMETRIC_EXAM_DATA_509850_9_getitemsByReferral'', @ErrorMsg, ''User is not part of this Registry'', @CURRENT_USER
		SELECT @ErrorMsg as [ErrorMsg];
		RETURN
	END

	SELECT
		[CRS].[A06_AUDIOMETRIC_EXAM_DATA_509850_9].*
	FROM 
		[CRS].[REFERRAL]
			INNER JOIN [CRS].[STD_REGISTRY] ON [CRS].[STD_REGISTRY].[ID] = [CRS].[REFERRAL].[STD_REGISTRY_ID]
			INNER JOIN [CRS].[PATIENT] ON [CRS].[PATIENT].[Patient_ID] = [CRS].[REFERRAL].[PATIENT_ID]
			INNER JOIN [CRS].[sPATIENT] ON [CRS].[sPATIENT].[PatientICN] = [CRS].[PATIENT].[PatientICN]
			INNER JOIN [CRS].[A06_AUDIOMETRIC_EXAM_DATA_509850_9] ON [CRS].[A06_AUDIOMETRIC_EXAM_DATA_509850_9].[ROW_ID] = [CRS].[sPATIENT].[PatientIEN]
	WHERE 
		[CRS].[REFERRAL].[REFERRAL_ID] = @REFERRAL_ID
		AND [CRS].[STD_REGISTRY].[INACTIVE_FLAG] = 0;
END





' 
END
GO

/****** Object:  StoredProcedure [CRS].[usp_A06_PHARMACY_PATIENT_55X_IV_55_01_getitemsByReferral]    Script Date: 12/8/2017 10:07:52 AM ******/
SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[CRS].[usp_A06_PHARMACY_PATIENT_55X_IV_55_01_getitemsByReferral]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'

-- =============================================
-- Author:        
-- Create date:   12/6/2017
-- Description:   Get all A06_PHARMACY_PATIENT_55X_IV_55_01 records by Referral
-- =============================================
CREATE PROCEDURE [CRS].[usp_A06_PHARMACY_PATIENT_55X_IV_55_01_getitemsByReferral] (@CURRENT_USER varchar(30), @CURRENT_REGISTRY_ID int, @REFERRAL_ID int)
AS
BEGIN
	-- SET NOCOUNT ON added to prevent extra result sets from
	-- interfering with SELECT statements.
	SET NOCOUNT ON;

	DECLARE @ErrorMsg varchar(max);

	IF ([CRS].[ValidateUser](@CURRENT_USER, @CURRENT_REGISTRY_ID) = 0)
	BEGIN
		SET @ErrorMsg = ''User is not authorized to perform this action.'';
		EXEC [CRS].[InsDBLog] @CURRENT_REGISTRY_ID, 0, ''CRS.usp_A06_PHARMACY_PATIENT_55X_IV_55_01_getitemsByReferral'', @ErrorMsg, ''User is not part of this Registry'', @CURRENT_USER
		SELECT @ErrorMsg as [ErrorMsg];
		RETURN
	END

	SELECT
		[CRS].[A06_PHARMACY_PATIENT_55X_IV_55_01].*
	FROM 
		[CRS].[REFERRAL]
			INNER JOIN [CRS].[STD_REGISTRY] ON [CRS].[STD_REGISTRY].[ID] = [CRS].[REFERRAL].[STD_REGISTRY_ID]
			INNER JOIN [CRS].[PATIENT] ON [CRS].[PATIENT].[Patient_ID] = [CRS].[REFERRAL].[PATIENT_ID]
			INNER JOIN [CRS].[sPATIENT] ON [CRS].[sPATIENT].[PatientICN] = [CRS].[PATIENT].[PatientICN]
			INNER JOIN [CRS].[A06_PHARMACY_PATIENT_55X_IV_55_01] ON [CRS].[A06_PHARMACY_PATIENT_55X_IV_55_01].[PHARMACY_PATIENT] = [CRS].[sPATIENT].[PatientIEN]
	WHERE 
		[CRS].[REFERRAL].[REFERRAL_ID] = @REFERRAL_ID
		AND [CRS].[STD_REGISTRY].[INACTIVE_FLAG] = 0;
END



' 
END
GO

/****** Object:  StoredProcedure [CRS].[usp_A06_PHARMACY_PATIX_UNIT_DOSE_55_06_getitemsByReferral]    Script Date: 12/8/2017 10:07:52 AM ******/
SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[CRS].[usp_A06_PHARMACY_PATIX_UNIT_DOSE_55_06_getitemsByReferral]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'

-- =============================================
-- Author:        
-- Create date:   12/6/2017
-- Description:   Get all A06_PHARMACY_PATIX_UNIT_DOSE_55_06 records by Referral
-- =============================================
CREATE PROCEDURE [CRS].[usp_A06_PHARMACY_PATIX_UNIT_DOSE_55_06_getitemsByReferral] (@CURRENT_USER varchar(30), @CURRENT_REGISTRY_ID int, @REFERRAL_ID int)
AS
BEGIN
	-- SET NOCOUNT ON added to prevent extra result sets from
	-- interfering with SELECT statements.
	SET NOCOUNT ON;

	DECLARE @ErrorMsg varchar(max);

	IF ([CRS].[ValidateUser](@CURRENT_USER, @CURRENT_REGISTRY_ID) = 0)
	BEGIN
		SET @ErrorMsg = ''User is not authorized to perform this action.'';
		EXEC [CRS].[InsDBLog] @CURRENT_REGISTRY_ID, 0, ''CRS.usp_A06_PHARMACY_PATIX_UNIT_DOSE_55_06_getitemsByReferral'', @ErrorMsg, ''User is not part of this Registry'', @CURRENT_USER
		SELECT @ErrorMsg as [ErrorMsg];
		RETURN
	END

	SELECT
		[CRS].[A06_PHARMACY_PATIX_UNIT_DOSE_55_06].*
	FROM 
		[CRS].[REFERRAL]
			INNER JOIN [CRS].[STD_REGISTRY] ON [CRS].[STD_REGISTRY].[ID] = [CRS].[REFERRAL].[STD_REGISTRY_ID]
			INNER JOIN [CRS].[PATIENT] ON [CRS].[PATIENT].[Patient_ID] = [CRS].[REFERRAL].[PATIENT_ID]
			INNER JOIN [CRS].[sPATIENT] ON [CRS].[sPATIENT].[PatientICN] = [CRS].[PATIENT].[PatientICN]
			INNER JOIN [CRS].[A06_PHARMACY_PATIX_UNIT_DOSE_55_06] ON [CRS].[A06_PHARMACY_PATIX_UNIT_DOSE_55_06].[PHARMACY_PATIENT] = [CRS].[sPATIENT].[PatientIEN]
	WHERE 
		[CRS].[REFERRAL].[REFERRAL_ID] = @REFERRAL_ID
		AND [CRS].[STD_REGISTRY].[INACTIVE_FLAG] = 0;
END



' 
END
GO

/****** Object:  StoredProcedure [CRS].[usp_A06_PHARMACY_PATX_NONVA_MEDS_55_05_getitemsByReferral]    Script Date: 12/8/2017 10:07:52 AM ******/
SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[CRS].[usp_A06_PHARMACY_PATX_NONVA_MEDS_55_05_getitemsByReferral]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'

-- =============================================
-- Author:        
-- Create date:   12/6/2017
-- Description:   Get all A06_PHARMACY_PATX_NONVA_MEDS_55_05 records by Referral
-- =============================================
CREATE PROCEDURE [CRS].[usp_A06_PHARMACY_PATX_NONVA_MEDS_55_05_getitemsByReferral] (@CURRENT_USER varchar(30), @CURRENT_REGISTRY_ID int, @REFERRAL_ID int)
AS
BEGIN
	-- SET NOCOUNT ON added to prevent extra result sets from
	-- interfering with SELECT statements.
	SET NOCOUNT ON;

	DECLARE @ErrorMsg varchar(max);

	IF ([CRS].[ValidateUser](@CURRENT_USER, @CURRENT_REGISTRY_ID) = 0)
	BEGIN
		SET @ErrorMsg = ''User is not authorized to perform this action.'';
		EXEC [CRS].[InsDBLog] @CURRENT_REGISTRY_ID, 0, ''CRS.usp_A06_PHARMACY_PATX_NONVA_MEDS_55_05_getitemsByReferral'', @ErrorMsg, ''User is not part of this Registry'', @CURRENT_USER
		SELECT @ErrorMsg as [ErrorMsg];
		RETURN
	END

	SELECT
		[CRS].[A06_PHARMACY_PATX_NONVA_MEDS_55_05].*
	FROM 
		[CRS].[REFERRAL]
			INNER JOIN [CRS].[STD_REGISTRY] ON [CRS].[STD_REGISTRY].[ID] = [CRS].[REFERRAL].[STD_REGISTRY_ID]
			INNER JOIN [CRS].[PATIENT] ON [CRS].[PATIENT].[Patient_ID] = [CRS].[REFERRAL].[PATIENT_ID]
			INNER JOIN [CRS].[sPATIENT] ON [CRS].[sPATIENT].[PatientICN] = [CRS].[PATIENT].[PatientICN]
			INNER JOIN [CRS].[A06_PHARMACY_PATX_NONVA_MEDS_55_05] ON [CRS].[A06_PHARMACY_PATX_NONVA_MEDS_55_05].[PHARMACY_PATIENT] = [CRS].[sPATIENT].[PatientIEN]
	WHERE 
		[CRS].[REFERRAL].[REFERRAL_ID] = @REFERRAL_ID
		AND [CRS].[STD_REGISTRY].[INACTIVE_FLAG] = 0;
END





' 
END
GO

/****** Object:  StoredProcedure [CRS].[usp_A06_SPATIENT_GEOCODEDADDRESS_getitemsByReferral]    Script Date: 12/8/2017 10:07:52 AM ******/
SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[CRS].[usp_A06_SPATIENT_GEOCODEDADDRESS_getitemsByReferral]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'

-- =============================================
-- Author:        
-- Create date:   12/6/2017
-- Description:   Get all A06_SPATIENT_GEOCODEDADDRESS records by Referral
-- =============================================
CREATE PROCEDURE [CRS].[usp_A06_SPATIENT_GEOCODEDADDRESS_getitemsByReferral] (@CURRENT_USER varchar(30), @CURRENT_REGISTRY_ID int, @REFERRAL_ID int)
AS
BEGIN
	-- SET NOCOUNT ON added to prevent extra result sets from
	-- interfering with SELECT statements.
	SET NOCOUNT ON;

	DECLARE @ErrorMsg varchar(max);

	IF ([CRS].[ValidateUser](@CURRENT_USER, @CURRENT_REGISTRY_ID) = 0)
	BEGIN
		SET @ErrorMsg = ''User is not authorized to perform this action.'';
		EXEC [CRS].[InsDBLog] @CURRENT_REGISTRY_ID, 0, ''CRS.usp_A06_SPATIENT_GEOCODEDADDRESS_getitemsByReferral'', @ErrorMsg, ''User is not part of this Registry'', @CURRENT_USER
		SELECT @ErrorMsg as [ErrorMsg];
		RETURN
	END

	SELECT
		[CRS].[A06_SPATIENT_GEOCODEDADDRESS].*
	FROM 
		[CRS].[REFERRAL]
			INNER JOIN [CRS].[STD_REGISTRY] ON [CRS].[STD_REGISTRY].[ID] = [CRS].[REFERRAL].[STD_REGISTRY_ID]
			INNER JOIN [CRS].[PATIENT] ON [CRS].[PATIENT].[Patient_ID] = [CRS].[REFERRAL].[PATIENT_ID]
			INNER JOIN [CRS].[sPATIENT] ON [CRS].[sPATIENT].[PatientICN] = [CRS].[PATIENT].[PatientICN]
			INNER JOIN [CRS].[A06_SPATIENT_GEOCODEDADDRESS] ON [CRS].[A06_SPATIENT_GEOCODEDADDRESS].[PatientICN] = [CRS].[sPATIENT].[PatientICN]
	WHERE 
		[CRS].[REFERRAL].[REFERRAL_ID] = @REFERRAL_ID
		AND [CRS].[STD_REGISTRY].[INACTIVE_FLAG] = 0;
END







' 
END
GO

/****** Object:  StoredProcedure [CRS].[usp_ALLERGY_getitemsByReferral]    Script Date: 12/8/2017 10:07:52 AM ******/
SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[CRS].[usp_ALLERGY_getitemsByReferral]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'


-- =============================================
-- Author:        
-- Create date:   12/6/2017
-- Description:   Get all Allergy records by Referral
-- =============================================
CREATE PROCEDURE [CRS].[usp_ALLERGY_getitemsByReferral] (@CURRENT_USER varchar(30), @CURRENT_REGISTRY_ID int, @REFERRAL_ID int)
AS
BEGIN
	-- SET NOCOUNT ON added to prevent extra result sets from
	-- interfering with SELECT statements.
	SET NOCOUNT ON;

	DECLARE @ErrorMsg varchar(max);

	IF ([CRS].[ValidateUser](@CURRENT_USER, @CURRENT_REGISTRY_ID) = 0)
	BEGIN
		SET @ErrorMsg = ''User is not authorized to perform this action.'';
		EXEC [CRS].[InsDBLog] @CURRENT_REGISTRY_ID, 0, ''CRS.usp_ALLERGY_getitemsByReferral'', @ErrorMsg, ''User is not part of this Registry'', @CURRENT_USER
		SELECT @ErrorMsg as [ErrorMsg];
		RETURN
	END

	SELECT
		[CRS].[ALLERGY].*
	FROM 
		[CRS].[REFERRAL]
			INNER JOIN [CRS].[STD_REGISTRY] ON [CRS].[STD_REGISTRY].[ID] = [CRS].[REFERRAL].[STD_REGISTRY_ID]
			INNER JOIN [CRS].[PATIENT] ON [CRS].[PATIENT].[Patient_ID] = [CRS].[REFERRAL].[PATIENT_ID]
			INNER JOIN [CRS].[sPATIENT] ON [CRS].[sPATIENT].[PatientICN] = [CRS].[PATIENT].[PatientICN]
			INNER JOIN [CRS].[ALLERGY] ON [CRS].[ALLERGY].[PATIENTSID] = [CRS].[sPATIENT].[PatientSID]
	WHERE 
		[CRS].[REFERRAL].[REFERRAL_ID] = @REFERRAL_ID
		AND [CRS].[STD_REGISTRY].[INACTIVE_FLAG] = 0;
END




' 
END
GO

/****** Object:  StoredProcedure [CRS].[usp_CHEM_LABCHEM_getitemsByReferral]    Script Date: 12/8/2017 10:07:52 AM ******/
SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[CRS].[usp_CHEM_LABCHEM_getitemsByReferral]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'



-- =============================================
-- Author:        
-- Create date:   12/6/2017
-- Description:   Get all CHEM_LABCHEM records by Referral
-- =============================================
CREATE PROCEDURE [CRS].[usp_CHEM_LABCHEM_getitemsByReferral] (@CURRENT_USER varchar(30), @CURRENT_REGISTRY_ID int, @REFERRAL_ID int)
AS
BEGIN
	-- SET NOCOUNT ON added to prevent extra result sets from
	-- interfering with SELECT statements.
	SET NOCOUNT ON;

	DECLARE @ErrorMsg varchar(max);

	IF ([CRS].[ValidateUser](@CURRENT_USER, @CURRENT_REGISTRY_ID) = 0)
	BEGIN
		SET @ErrorMsg = ''User is not authorized to perform this action.'';
		EXEC [CRS].[InsDBLog] @CURRENT_REGISTRY_ID, 0, ''CRS.usp_CHEM_LABCHEM_getitemsByReferral'', @ErrorMsg, ''User is not part of this Registry'', @CURRENT_USER
		SELECT @ErrorMsg as [ErrorMsg];
		RETURN
	END

	SELECT
		[CRS].[CHEM_LABCHEM].*
	FROM 
		[CRS].[REFERRAL]
			INNER JOIN [CRS].[STD_REGISTRY] ON [CRS].[STD_REGISTRY].[ID] = [CRS].[REFERRAL].[STD_REGISTRY_ID]
			INNER JOIN [CRS].[PATIENT] ON [CRS].[PATIENT].[Patient_ID] = [CRS].[REFERRAL].[PATIENT_ID]
			INNER JOIN [CRS].[sPATIENT] ON [CRS].[sPATIENT].[PatientICN] = [CRS].[PATIENT].[PatientICN]
			INNER JOIN [CRS].[CHEM_LABCHEM] ON [CRS].[CHEM_LABCHEM].[PATIENTSID] = [CRS].[sPATIENT].[PatientSID]
	WHERE 
		[CRS].[REFERRAL].[REFERRAL_ID] = @REFERRAL_ID
		AND [CRS].[STD_REGISTRY].[INACTIVE_FLAG] = 0;
END







' 
END
GO

/****** Object:  StoredProcedure [CRS].[usp_Consult_getitemsByReferral]    Script Date: 12/8/2017 10:07:52 AM ******/
SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[CRS].[usp_Consult_getitemsByReferral]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'



-- =============================================
-- Author:        
-- Create date:   12/6/2017
-- Description:   Get all Consult records by Referral
-- =============================================
CREATE PROCEDURE [CRS].[usp_Consult_getitemsByReferral] (@CURRENT_USER varchar(30), @CURRENT_REGISTRY_ID int, @REFERRAL_ID int)
AS
BEGIN
	-- SET NOCOUNT ON added to prevent extra result sets from
	-- interfering with SELECT statements.
	SET NOCOUNT ON;

	DECLARE @ErrorMsg varchar(max);

	IF ([CRS].[ValidateUser](@CURRENT_USER, @CURRENT_REGISTRY_ID) = 0)
	BEGIN
		SET @ErrorMsg = ''User is not authorized to perform this action.'';
		EXEC [CRS].[InsDBLog] @CURRENT_REGISTRY_ID, 0, ''CRS.usp_Consult_getitemsByReferral'', @ErrorMsg, ''User is not part of this Registry'', @CURRENT_USER
		SELECT @ErrorMsg as [ErrorMsg];
		RETURN
	END

	SELECT
		[CRS].[Consult].*
	FROM 
		[CRS].[REFERRAL]
			INNER JOIN [CRS].[STD_REGISTRY] ON [CRS].[STD_REGISTRY].[ID] = [CRS].[REFERRAL].[STD_REGISTRY_ID]
			INNER JOIN [CRS].[PATIENT] ON [CRS].[PATIENT].[Patient_ID] = [CRS].[REFERRAL].[PATIENT_ID]
			INNER JOIN [CRS].[sPATIENT] ON [CRS].[sPATIENT].[PatientICN] = [CRS].[PATIENT].[PatientICN]
			INNER JOIN [CRS].[Consult] ON [CRS].[Consult].[PATIENTSID] = [CRS].[sPATIENT].[PatientSID]
	WHERE 
		[CRS].[REFERRAL].[REFERRAL_ID] = @REFERRAL_ID
		AND [CRS].[STD_REGISTRY].[INACTIVE_FLAG] = 0;
END




' 
END
GO

/****** Object:  StoredProcedure [CRS].[usp_EDISLOG_getitemsByReferral]    Script Date: 12/8/2017 10:07:52 AM ******/
SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[CRS].[usp_EDISLOG_getitemsByReferral]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'





-- =============================================
-- Author:        
-- Create date:   12/6/2017
-- Description:   Get all EDISLOG records by Referral
-- =============================================
CREATE PROCEDURE [CRS].[usp_EDISLOG_getitemsByReferral] (@CURRENT_USER varchar(30), @CURRENT_REGISTRY_ID int, @REFERRAL_ID int)
AS
BEGIN
	-- SET NOCOUNT ON added to prevent extra result sets from
	-- interfering with SELECT statements.
	SET NOCOUNT ON;

	DECLARE @ErrorMsg varchar(max);

	IF ([CRS].[ValidateUser](@CURRENT_USER, @CURRENT_REGISTRY_ID) = 0)
	BEGIN
		SET @ErrorMsg = ''User is not authorized to perform this action.'';
		EXEC [CRS].[InsDBLog] @CURRENT_REGISTRY_ID, 0, ''CRS.usp_EDISLOG_getitemsByReferral'', @ErrorMsg, ''User is not part of this Registry'', @CURRENT_USER
		SELECT @ErrorMsg as [ErrorMsg];
		RETURN
	END

	SELECT
		[CRS].[EDISLOG].*
	FROM 
		[CRS].[REFERRAL]
			INNER JOIN [CRS].[STD_REGISTRY] ON [CRS].[STD_REGISTRY].[ID] = [CRS].[REFERRAL].[STD_REGISTRY_ID]
			INNER JOIN [CRS].[PATIENT] ON [CRS].[PATIENT].[Patient_ID] = [CRS].[REFERRAL].[PATIENT_ID]
			INNER JOIN [CRS].[sPATIENT] ON [CRS].[sPATIENT].[PatientICN] = [CRS].[PATIENT].[PatientICN]
			INNER JOIN [CRS].[EDISLOG] ON [CRS].[EDISLOG].[PATIENTSID] = [CRS].[sPATIENT].[PatientSID]
	WHERE 
		[CRS].[REFERRAL].[REFERRAL_ID] = @REFERRAL_ID
		AND [CRS].[STD_REGISTRY].[INACTIVE_FLAG] = 0;
END







' 
END
GO

/****** Object:  StoredProcedure [CRS].[usp_Immunization_getitemsByReferral]    Script Date: 12/8/2017 10:07:52 AM ******/
SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[CRS].[usp_Immunization_getitemsByReferral]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'




-- =============================================
-- Author:        
-- Create date:   12/6/2017
-- Description:   Get all Immunization records by Referral
-- =============================================
CREATE PROCEDURE [CRS].[usp_Immunization_getitemsByReferral] (@CURRENT_USER varchar(30), @CURRENT_REGISTRY_ID int, @REFERRAL_ID int)
AS
BEGIN
	-- SET NOCOUNT ON added to prevent extra result sets from
	-- interfering with SELECT statements.
	SET NOCOUNT ON;

	DECLARE @ErrorMsg varchar(max);

	IF ([CRS].[ValidateUser](@CURRENT_USER, @CURRENT_REGISTRY_ID) = 0)
	BEGIN
		SET @ErrorMsg = ''User is not authorized to perform this action.'';
		EXEC [CRS].[InsDBLog] @CURRENT_REGISTRY_ID, 0, ''CRS.usp_Immunization_getitemsByReferral'', @ErrorMsg, ''User is not part of this Registry'', @CURRENT_USER
		SELECT @ErrorMsg as [ErrorMsg];
		RETURN
	END

	SELECT
		[CRS].[Immunization].*
	FROM 
		[CRS].[REFERRAL]
			INNER JOIN [CRS].[STD_REGISTRY] ON [CRS].[STD_REGISTRY].[ID] = [CRS].[REFERRAL].[STD_REGISTRY_ID]
			INNER JOIN [CRS].[PATIENT] ON [CRS].[PATIENT].[Patient_ID] = [CRS].[REFERRAL].[PATIENT_ID]
			INNER JOIN [CRS].[sPATIENT] ON [CRS].[sPATIENT].[PatientICN] = [CRS].[PATIENT].[PatientICN]
			INNER JOIN [CRS].[Immunization] ON [CRS].[Immunization].[PATIENTSID] = [CRS].[sPATIENT].[PatientSID]
	WHERE 
		[CRS].[REFERRAL].[REFERRAL_ID] = @REFERRAL_ID
		AND [CRS].[STD_REGISTRY].[INACTIVE_FLAG] = 0;
END






' 
END
GO

/****** Object:  StoredProcedure [CRS].[usp_INPAT_CENSUS_getitemsByReferral]    Script Date: 12/8/2017 10:07:52 AM ******/
SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[CRS].[usp_INPAT_CENSUS_getitemsByReferral]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'




-- =============================================
-- Author:        
-- Create date:   12/6/2017
-- Description:   Get all INPAT_CENSUS records by Referral
-- =============================================
CREATE PROCEDURE [CRS].[usp_INPAT_CENSUS_getitemsByReferral] (@CURRENT_USER varchar(30), @CURRENT_REGISTRY_ID int, @REFERRAL_ID int)
AS
BEGIN
	-- SET NOCOUNT ON added to prevent extra result sets from
	-- interfering with SELECT statements.
	SET NOCOUNT ON;

	DECLARE @ErrorMsg varchar(max);

	IF ([CRS].[ValidateUser](@CURRENT_USER, @CURRENT_REGISTRY_ID) = 0)
	BEGIN
		SET @ErrorMsg = ''User is not authorized to perform this action.'';
		EXEC [CRS].[InsDBLog] @CURRENT_REGISTRY_ID, 0, ''CRS.usp_INPAT_CENSUS_getitemsByReferral'', @ErrorMsg, ''User is not part of this Registry'', @CURRENT_USER
		SELECT @ErrorMsg as [ErrorMsg];
		RETURN
	END

	SELECT
		[CRS].[INPAT_CENSUS].*
	FROM 
		[CRS].[REFERRAL]
			INNER JOIN [CRS].[STD_REGISTRY] ON [CRS].[STD_REGISTRY].[ID] = [CRS].[REFERRAL].[STD_REGISTRY_ID]
			INNER JOIN [CRS].[PATIENT] ON [CRS].[PATIENT].[Patient_ID] = [CRS].[REFERRAL].[PATIENT_ID]
			INNER JOIN [CRS].[sPATIENT] ON [CRS].[sPATIENT].[PatientICN] = [CRS].[PATIENT].[PatientICN]
			INNER JOIN [CRS].[INPAT_CENSUS] ON [CRS].[INPAT_CENSUS].[PATIENTSID] = [CRS].[sPATIENT].[PatientSID]
	WHERE 
		[CRS].[REFERRAL].[REFERRAL_ID] = @REFERRAL_ID
		AND [CRS].[STD_REGISTRY].[INACTIVE_FLAG] = 0;
END




' 
END
GO

/****** Object:  StoredProcedure [CRS].[usp_INPAT_INPATIENT_getitemsByReferral]    Script Date: 12/8/2017 10:07:52 AM ******/
SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[CRS].[usp_INPAT_INPATIENT_getitemsByReferral]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'





-- =============================================
-- Author:        
-- Create date:   12/6/2017
-- Description:   Get all INPAT_INPATIENT records by Referral
-- =============================================
CREATE PROCEDURE [CRS].[usp_INPAT_INPATIENT_getitemsByReferral] (@CURRENT_USER varchar(30), @CURRENT_REGISTRY_ID int, @REFERRAL_ID int)
AS
BEGIN
	-- SET NOCOUNT ON added to prevent extra result sets from
	-- interfering with SELECT statements.
	SET NOCOUNT ON;

	DECLARE @ErrorMsg varchar(max);

	IF ([CRS].[ValidateUser](@CURRENT_USER, @CURRENT_REGISTRY_ID) = 0)
	BEGIN
		SET @ErrorMsg = ''User is not authorized to perform this action.'';
		EXEC [CRS].[InsDBLog] @CURRENT_REGISTRY_ID, 0, ''CRS.usp_INPAT_INPATIENT_getitemsByReferral'', @ErrorMsg, ''User is not part of this Registry'', @CURRENT_USER
		SELECT @ErrorMsg as [ErrorMsg];
		RETURN
	END

	SELECT
		[CRS].[INPAT_INPATIENT].*
	FROM 
		[CRS].[REFERRAL]
			INNER JOIN [CRS].[STD_REGISTRY] ON [CRS].[STD_REGISTRY].[ID] = [CRS].[REFERRAL].[STD_REGISTRY_ID]
			INNER JOIN [CRS].[PATIENT] ON [CRS].[PATIENT].[Patient_ID] = [CRS].[REFERRAL].[PATIENT_ID]
			INNER JOIN [CRS].[sPATIENT] ON [CRS].[sPATIENT].[PatientICN] = [CRS].[PATIENT].[PatientICN]
			INNER JOIN [CRS].[INPAT_INPATIENT] ON [CRS].[INPAT_INPATIENT].[PATIENTSID] = [CRS].[sPATIENT].[PatientSID]
	WHERE 
		[CRS].[REFERRAL].[REFERRAL_ID] = @REFERRAL_ID
		AND [CRS].[STD_REGISTRY].[INACTIVE_FLAG] = 0;
END






' 
END
GO

/****** Object:  StoredProcedure [CRS].[usp_INPATIENT_DIAGNOSIS_getitemsByReferral]    Script Date: 12/8/2017 10:07:52 AM ******/
SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[CRS].[usp_INPATIENT_DIAGNOSIS_getitemsByReferral]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'




-- =============================================
-- Author:        
-- Create date:   12/6/2017
-- Description:   Get all INPATIENT_DIAGNOSIS records by Referral
-- =============================================
CREATE PROCEDURE [CRS].[usp_INPATIENT_DIAGNOSIS_getitemsByReferral] (@CURRENT_USER varchar(30), @CURRENT_REGISTRY_ID int, @REFERRAL_ID int)
AS
BEGIN
	-- SET NOCOUNT ON added to prevent extra result sets from
	-- interfering with SELECT statements.
	SET NOCOUNT ON;

	DECLARE @ErrorMsg varchar(max);

	IF ([CRS].[ValidateUser](@CURRENT_USER, @CURRENT_REGISTRY_ID) = 0)
	BEGIN
		SET @ErrorMsg = ''User is not authorized to perform this action.'';
		EXEC [CRS].[InsDBLog] @CURRENT_REGISTRY_ID, 0, ''CRS.usp_INPATIENT_DIAGNOSIS_getitemsByReferral'', @ErrorMsg, ''User is not part of this Registry'', @CURRENT_USER
		SELECT @ErrorMsg as [ErrorMsg];
		RETURN
	END

	SELECT
		[CRS].[INPATIENT_DIAGNOSIS].*
	FROM 
		[CRS].[REFERRAL]
			INNER JOIN [CRS].[STD_REGISTRY] ON [CRS].[STD_REGISTRY].[ID] = [CRS].[REFERRAL].[STD_REGISTRY_ID]
			INNER JOIN [CRS].[PATIENT] ON [CRS].[PATIENT].[Patient_ID] = [CRS].[REFERRAL].[PATIENT_ID]
			INNER JOIN [CRS].[sPATIENT] ON [CRS].[sPATIENT].[PatientICN] = [CRS].[PATIENT].[PatientICN]
			INNER JOIN [CRS].[INPATIENT_DIAGNOSIS] ON [CRS].[INPATIENT_DIAGNOSIS].[PATIENTSID] = [CRS].[sPATIENT].[PatientSID]
	WHERE 
		[CRS].[REFERRAL].[REFERRAL_ID] = @REFERRAL_ID
		AND [CRS].[STD_REGISTRY].[INACTIVE_FLAG] = 0;
END






' 
END
GO

/****** Object:  StoredProcedure [CRS].[usp_MILITARY_SERVICE_EPISODE_getitemsByReferral]    Script Date: 12/8/2017 10:07:52 AM ******/
SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[CRS].[usp_MILITARY_SERVICE_EPISODE_getitemsByReferral]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'

-- =============================================
-- Author:        
-- Create date:   12/6/2017
-- Description:   Get all MILITARY_SERVICE_EPISODE records by Referral
-- =============================================
CREATE PROCEDURE [CRS].[usp_MILITARY_SERVICE_EPISODE_getitemsByReferral] (@CURRENT_USER varchar(30), @CURRENT_REGISTRY_ID int, @REFERRAL_ID int)
AS
BEGIN
	-- SET NOCOUNT ON added to prevent extra result sets from
	-- interfering with SELECT statements.
	SET NOCOUNT ON;

	DECLARE @ErrorMsg varchar(max);

	IF ([CRS].[ValidateUser](@CURRENT_USER, @CURRENT_REGISTRY_ID) = 0)
	BEGIN
		SET @ErrorMsg = ''User is not authorized to perform this action.'';
		EXEC [CRS].[InsDBLog] @CURRENT_REGISTRY_ID, 0, ''CRS.usp_MILITARY_SERVICE_EPISODE_getitemsByReferral'', @ErrorMsg, ''User is not part of this Registry'', @CURRENT_USER
		SELECT @ErrorMsg as [ErrorMsg];
		RETURN
	END

	SELECT
		[CRS].[MILITARY_SERVICE_EPISODE].*
	FROM 
		[CRS].[REFERRAL]
			INNER JOIN [CRS].[STD_REGISTRY] ON [CRS].[STD_REGISTRY].[ID] = [CRS].[REFERRAL].[STD_REGISTRY_ID]
			INNER JOIN [CRS].[PATIENT] ON [CRS].[PATIENT].[Patient_ID] = [CRS].[REFERRAL].[PATIENT_ID]
			INNER JOIN [CRS].[sPATIENT] ON [CRS].[sPATIENT].[PatientICN] = [CRS].[PATIENT].[PatientICN]
			INNER JOIN [CRS].[MILITARY_SERVICE_EPISODE] ON [CRS].[MILITARY_SERVICE_EPISODE].[PatientSID] = [CRS].[sPATIENT].[PatientSID]
	WHERE 
		[CRS].[REFERRAL].[REFERRAL_ID] = @REFERRAL_ID
		AND [CRS].[STD_REGISTRY].[INACTIVE_FLAG] = 0;
END






' 
END
GO

/****** Object:  StoredProcedure [CRS].[usp_MILITARY_SEXUAL_TRAUMA_getitemsByReferral]    Script Date: 12/8/2017 10:07:52 AM ******/
SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[CRS].[usp_MILITARY_SEXUAL_TRAUMA_getitemsByReferral]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'

-- =============================================
-- Author:        
-- Create date:   12/6/2017
-- Description:   Get all MILITARY_SEXUAL_TRAUMA records by Referral
-- =============================================
CREATE PROCEDURE [CRS].[usp_MILITARY_SEXUAL_TRAUMA_getitemsByReferral] (@CURRENT_USER varchar(30), @CURRENT_REGISTRY_ID int, @REFERRAL_ID int)
AS
BEGIN
	-- SET NOCOUNT ON added to prevent extra result sets from
	-- interfering with SELECT statements.
	SET NOCOUNT ON;

	DECLARE @ErrorMsg varchar(max);

	IF ([CRS].[ValidateUser](@CURRENT_USER, @CURRENT_REGISTRY_ID) = 0)
	BEGIN
		SET @ErrorMsg = ''User is not authorized to perform this action.'';
		EXEC [CRS].[InsDBLog] @CURRENT_REGISTRY_ID, 0, ''CRS.usp_MILITARY_SEXUAL_TRAUMA_getitemsByReferral'', @ErrorMsg, ''User is not part of this Registry'', @CURRENT_USER
		SELECT @ErrorMsg as [ErrorMsg];
		RETURN
	END

	SELECT
		[CRS].[MILITARY_SEXUAL_TRAUMA].*
	FROM 
		[CRS].[REFERRAL]
			INNER JOIN [CRS].[STD_REGISTRY] ON [CRS].[STD_REGISTRY].[ID] = [CRS].[REFERRAL].[STD_REGISTRY_ID]
			INNER JOIN [CRS].[PATIENT] ON [CRS].[PATIENT].[Patient_ID] = [CRS].[REFERRAL].[PATIENT_ID]
			INNER JOIN [CRS].[sPATIENT] ON [CRS].[sPATIENT].[PatientICN] = [CRS].[PATIENT].[PatientICN]
			INNER JOIN [CRS].[MILITARY_SEXUAL_TRAUMA] ON [CRS].[MILITARY_SEXUAL_TRAUMA].[PatientSID] = [CRS].[sPATIENT].[PatientSID]
	WHERE 
		[CRS].[REFERRAL].[REFERRAL_ID] = @REFERRAL_ID
		AND [CRS].[STD_REGISTRY].[INACTIVE_FLAG] = 0;
END








' 
END
GO

/****** Object:  StoredProcedure [CRS].[usp_NOSETHROAT_RADIUMHST_getitemsByReferral]    Script Date: 12/8/2017 10:07:52 AM ******/
SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[CRS].[usp_NOSETHROAT_RADIUMHST_getitemsByReferral]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'

-- =============================================
-- Author:        
-- Create date:   12/6/2017
-- Description:   Get all NOSETHROAT_RADIUMHST records by Referral
-- =============================================
CREATE PROCEDURE [CRS].[usp_NOSETHROAT_RADIUMHST_getitemsByReferral] (@CURRENT_USER varchar(30), @CURRENT_REGISTRY_ID int, @REFERRAL_ID int)
AS
BEGIN
	-- SET NOCOUNT ON added to prevent extra result sets from
	-- interfering with SELECT statements.
	SET NOCOUNT ON;

	DECLARE @ErrorMsg varchar(max);

	IF ([CRS].[ValidateUser](@CURRENT_USER, @CURRENT_REGISTRY_ID) = 0)
	BEGIN
		SET @ErrorMsg = ''User is not authorized to perform this action.'';
		EXEC [CRS].[InsDBLog] @CURRENT_REGISTRY_ID, 0, ''CRS.usp_NOSETHROAT_RADIUMHST_getitemsByReferral'', @ErrorMsg, ''User is not part of this Registry'', @CURRENT_USER
		SELECT @ErrorMsg as [ErrorMsg];
		RETURN
	END

	SELECT
		[CRS].[NOSETHROAT_RADIUMHST].*
	FROM 
		[CRS].[REFERRAL]
			INNER JOIN [CRS].[STD_REGISTRY] ON [CRS].[STD_REGISTRY].[ID] = [CRS].[REFERRAL].[STD_REGISTRY_ID]
			INNER JOIN [CRS].[PATIENT] ON [CRS].[PATIENT].[Patient_ID] = [CRS].[REFERRAL].[PATIENT_ID]
			INNER JOIN [CRS].[sPATIENT] ON [CRS].[sPATIENT].[PatientICN] = [CRS].[PATIENT].[PatientICN]
			INNER JOIN [CRS].[NOSETHROAT_RADIUMHST] ON [CRS].[NOSETHROAT_RADIUMHST].[PatientSID] = [CRS].[sPATIENT].[PatientSID]
	WHERE 
		[CRS].[REFERRAL].[REFERRAL_ID] = @REFERRAL_ID
		AND [CRS].[STD_REGISTRY].[INACTIVE_FLAG] = 0;
END







' 
END
GO

/****** Object:  StoredProcedure [CRS].[usp_OEFOIF_SERVICE_getitemsByReferral]    Script Date: 12/8/2017 10:07:52 AM ******/
SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[CRS].[usp_OEFOIF_SERVICE_getitemsByReferral]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'

-- =============================================
-- Author:        
-- Create date:   12/6/2017
-- Description:   Get all OEFOIF_SERVICE records by Referral
-- =============================================
CREATE PROCEDURE [CRS].[usp_OEFOIF_SERVICE_getitemsByReferral] (@CURRENT_USER varchar(30), @CURRENT_REGISTRY_ID int, @REFERRAL_ID int)
AS
BEGIN
	-- SET NOCOUNT ON added to prevent extra result sets from
	-- interfering with SELECT statements.
	SET NOCOUNT ON;

	DECLARE @ErrorMsg varchar(max);

	IF ([CRS].[ValidateUser](@CURRENT_USER, @CURRENT_REGISTRY_ID) = 0)
	BEGIN
		SET @ErrorMsg = ''User is not authorized to perform this action.'';
		EXEC [CRS].[InsDBLog] @CURRENT_REGISTRY_ID, 0, ''CRS.usp_OEFOIF_SERVICE_getitemsByReferral'', @ErrorMsg, ''User is not part of this Registry'', @CURRENT_USER
		SELECT @ErrorMsg as [ErrorMsg];
		RETURN
	END

	SELECT
		[CRS].[OEFOIF_SERVICE].*
	FROM 
		[CRS].[REFERRAL]
			INNER JOIN [CRS].[STD_REGISTRY] ON [CRS].[STD_REGISTRY].[ID] = [CRS].[REFERRAL].[STD_REGISTRY_ID]
			INNER JOIN [CRS].[PATIENT] ON [CRS].[PATIENT].[Patient_ID] = [CRS].[REFERRAL].[PATIENT_ID]
			INNER JOIN [CRS].[sPATIENT] ON [CRS].[sPATIENT].[PatientICN] = [CRS].[PATIENT].[PatientICN]
			INNER JOIN [CRS].[OEFOIF_SERVICE] ON [CRS].[OEFOIF_SERVICE].[PatientSID] = [CRS].[sPATIENT].[PatientSID]
	WHERE 
		[CRS].[REFERRAL].[REFERRAL_ID] = @REFERRAL_ID
		AND [CRS].[STD_REGISTRY].[INACTIVE_FLAG] = 0;
END





' 
END
GO

/****** Object:  StoredProcedure [CRS].[usp_OUTPAT_PROBLEMLIST_getitemsByReferral]    Script Date: 12/8/2017 10:07:52 AM ******/
SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[CRS].[usp_OUTPAT_PROBLEMLIST_getitemsByReferral]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'

-- =============================================
-- Author:        
-- Create date:   12/6/2017
-- Description:   Get all OUTPAT_PROBLEMLIST records by Referral
-- =============================================
CREATE PROCEDURE [CRS].[usp_OUTPAT_PROBLEMLIST_getitemsByReferral] (@CURRENT_USER varchar(30), @CURRENT_REGISTRY_ID int, @REFERRAL_ID int)
AS
BEGIN
	-- SET NOCOUNT ON added to prevent extra result sets from
	-- interfering with SELECT statements.
	SET NOCOUNT ON;

	DECLARE @ErrorMsg varchar(max);

	IF ([CRS].[ValidateUser](@CURRENT_USER, @CURRENT_REGISTRY_ID) = 0)
	BEGIN
		SET @ErrorMsg = ''User is not authorized to perform this action.'';
		EXEC [CRS].[InsDBLog] @CURRENT_REGISTRY_ID, 0, ''CRS.usp_OUTPAT_PROBLEMLIST_getitemsByReferral'', @ErrorMsg, ''User is not part of this Registry'', @CURRENT_USER
		SELECT @ErrorMsg as [ErrorMsg];
		RETURN
	END

	SELECT
		[CRS].[OUTPAT_PROBLEMLIST].*
	FROM 
		[CRS].[REFERRAL]
			INNER JOIN [CRS].[STD_REGISTRY] ON [CRS].[STD_REGISTRY].[ID] = [CRS].[REFERRAL].[STD_REGISTRY_ID]
			INNER JOIN [CRS].[PATIENT] ON [CRS].[PATIENT].[Patient_ID] = [CRS].[REFERRAL].[PATIENT_ID]
			INNER JOIN [CRS].[sPATIENT] ON [CRS].[sPATIENT].[PatientICN] = [CRS].[PATIENT].[PatientICN]
			INNER JOIN [CRS].[OUTPAT_PROBLEMLIST] ON [CRS].[OUTPAT_PROBLEMLIST].[PatientSID] = [CRS].[sPATIENT].[PatientSID]
	WHERE 
		[CRS].[REFERRAL].[REFERRAL_ID] = @REFERRAL_ID
		AND [CRS].[STD_REGISTRY].[INACTIVE_FLAG] = 0;
END









' 
END
GO

/****** Object:  StoredProcedure [CRS].[usp_OUTPAT_VDIAGNOSIS_getitemsByReferral]    Script Date: 12/8/2017 10:07:52 AM ******/
SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[CRS].[usp_OUTPAT_VDIAGNOSIS_getitemsByReferral]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'

-- =============================================
-- Author:        
-- Create date:   12/6/2017
-- Description:   Get all OUTPAT_VDIAGNOSIS records by Referral
-- =============================================
CREATE PROCEDURE [CRS].[usp_OUTPAT_VDIAGNOSIS_getitemsByReferral] (@CURRENT_USER varchar(30), @CURRENT_REGISTRY_ID int, @REFERRAL_ID int)
AS
BEGIN
	-- SET NOCOUNT ON added to prevent extra result sets from
	-- interfering with SELECT statements.
	SET NOCOUNT ON;

	DECLARE @ErrorMsg varchar(max);

	IF ([CRS].[ValidateUser](@CURRENT_USER, @CURRENT_REGISTRY_ID) = 0)
	BEGIN
		SET @ErrorMsg = ''User is not authorized to perform this action.'';
		EXEC [CRS].[InsDBLog] @CURRENT_REGISTRY_ID, 0, ''CRS.usp_OUTPAT_VDIAGNOSIS_getitemsByReferral'', @ErrorMsg, ''User is not part of this Registry'', @CURRENT_USER
		SELECT @ErrorMsg as [ErrorMsg];
		RETURN
	END

	SELECT
		[CRS].[OUTPAT_VDIAGNOSIS].*
	FROM 
		[CRS].[REFERRAL]
			INNER JOIN [CRS].[STD_REGISTRY] ON [CRS].[STD_REGISTRY].[ID] = [CRS].[REFERRAL].[STD_REGISTRY_ID]
			INNER JOIN [CRS].[PATIENT] ON [CRS].[PATIENT].[Patient_ID] = [CRS].[REFERRAL].[PATIENT_ID]
			INNER JOIN [CRS].[sPATIENT] ON [CRS].[sPATIENT].[PatientICN] = [CRS].[PATIENT].[PatientICN]
			INNER JOIN [CRS].[OUTPAT_VDIAGNOSIS] ON [CRS].[OUTPAT_VDIAGNOSIS].[PatientSID] = [CRS].[sPATIENT].[PatientSID]
	WHERE 
		[CRS].[REFERRAL].[REFERRAL_ID] = @REFERRAL_ID
		AND [CRS].[STD_REGISTRY].[INACTIVE_FLAG] = 0;
END








' 
END
GO

/****** Object:  StoredProcedure [CRS].[usp_PATIENT_ENROLLMENT_getitemsByReferral]    Script Date: 12/8/2017 10:07:52 AM ******/
SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[CRS].[usp_PATIENT_ENROLLMENT_getitemsByReferral]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'

-- =============================================
-- Author:        
-- Create date:   12/6/2017
-- Description:   Get all PATIENT_ENROLLMENT records by Referral
-- =============================================
CREATE PROCEDURE [CRS].[usp_PATIENT_ENROLLMENT_getitemsByReferral] (@CURRENT_USER varchar(30), @CURRENT_REGISTRY_ID int, @REFERRAL_ID int)
AS
BEGIN
	-- SET NOCOUNT ON added to prevent extra result sets from
	-- interfering with SELECT statements.
	SET NOCOUNT ON;

	DECLARE @ErrorMsg varchar(max);

	IF ([CRS].[ValidateUser](@CURRENT_USER, @CURRENT_REGISTRY_ID) = 0)
	BEGIN
		SET @ErrorMsg = ''User is not authorized to perform this action.'';
		EXEC [CRS].[InsDBLog] @CURRENT_REGISTRY_ID, 0, ''CRS.usp_PATIENT_ENROLLMENT_getitemsByReferral'', @ErrorMsg, ''User is not part of this Registry'', @CURRENT_USER
		SELECT @ErrorMsg as [ErrorMsg];
		RETURN
	END

	SELECT
		[CRS].[PATIENT_ENROLLMENT].*
	FROM 
		[CRS].[REFERRAL]
			INNER JOIN [CRS].[STD_REGISTRY] ON [CRS].[STD_REGISTRY].[ID] = [CRS].[REFERRAL].[STD_REGISTRY_ID]
			INNER JOIN [CRS].[PATIENT] ON [CRS].[PATIENT].[Patient_ID] = [CRS].[REFERRAL].[PATIENT_ID]
			INNER JOIN [CRS].[sPATIENT] ON [CRS].[sPATIENT].[PatientICN] = [CRS].[PATIENT].[PatientICN]
			INNER JOIN [CRS].[PATIENT_ENROLLMENT] ON [CRS].[PATIENT_ENROLLMENT].[PATIENTSID] = [CRS].[sPATIENT].[PatientSID]
	WHERE 
		[CRS].[REFERRAL].[REFERRAL_ID] = @REFERRAL_ID
		AND [CRS].[STD_REGISTRY].[INACTIVE_FLAG] = 0;
END




' 
END
GO

/****** Object:  StoredProcedure [CRS].[usp_PATIENT_ETHNICITY_getitemsByReferral]    Script Date: 12/8/2017 10:07:52 AM ******/
SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[CRS].[usp_PATIENT_ETHNICITY_getitemsByReferral]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'

-- =============================================
-- Author:        
-- Create date:   12/6/2017
-- Description:   Get all PATIENT_ETHNICITY records by Referral
-- =============================================
CREATE PROCEDURE [CRS].[usp_PATIENT_ETHNICITY_getitemsByReferral] (@CURRENT_USER varchar(30), @CURRENT_REGISTRY_ID int, @REFERRAL_ID int)
AS
BEGIN
	-- SET NOCOUNT ON added to prevent extra result sets from
	-- interfering with SELECT statements.
	SET NOCOUNT ON;

	DECLARE @ErrorMsg varchar(max);

	IF ([CRS].[ValidateUser](@CURRENT_USER, @CURRENT_REGISTRY_ID) = 0)
	BEGIN
		SET @ErrorMsg = ''User is not authorized to perform this action.'';
		EXEC [CRS].[InsDBLog] @CURRENT_REGISTRY_ID, 0, ''CRS.usp_PATIENT_ETHNICITY_getitemsByReferral'', @ErrorMsg, ''User is not part of this Registry'', @CURRENT_USER
		SELECT @ErrorMsg as [ErrorMsg];
		RETURN
	END

	SELECT
		[CRS].[PATIENT_ETHNICITY].*
	FROM 
		[CRS].[REFERRAL]
			INNER JOIN [CRS].[STD_REGISTRY] ON [CRS].[STD_REGISTRY].[ID] = [CRS].[REFERRAL].[STD_REGISTRY_ID]
			INNER JOIN [CRS].[PATIENT] ON [CRS].[PATIENT].[Patient_ID] = [CRS].[REFERRAL].[PATIENT_ID]
			INNER JOIN [CRS].[sPATIENT] ON [CRS].[sPATIENT].[PatientICN] = [CRS].[PATIENT].[PatientICN]
			INNER JOIN [CRS].[PATIENT_ETHNICITY] ON [CRS].[PATIENT_ETHNICITY].[PATIENTSID] = [CRS].[sPATIENT].[PatientSID]
	WHERE 
		[CRS].[REFERRAL].[REFERRAL_ID] = @REFERRAL_ID
		AND [CRS].[STD_REGISTRY].[INACTIVE_FLAG] = 0;
END








' 
END
GO

/****** Object:  StoredProcedure [CRS].[usp_PATSUB_SECONDARYELIGIBILITY_getitemsByReferral]    Script Date: 12/8/2017 10:07:52 AM ******/
SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[CRS].[usp_PATSUB_SECONDARYELIGIBILITY_getitemsByReferral]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'

-- =============================================
-- Author:        
-- Create date:   12/6/2017
-- Description:   Get all PATSUB_SECONDARYELIGIBILITY records by Referral
-- =============================================
CREATE PROCEDURE [CRS].[usp_PATSUB_SECONDARYELIGIBILITY_getitemsByReferral] (@CURRENT_USER varchar(30), @CURRENT_REGISTRY_ID int, @REFERRAL_ID int)
AS
BEGIN
	-- SET NOCOUNT ON added to prevent extra result sets from
	-- interfering with SELECT statements.
	SET NOCOUNT ON;

	DECLARE @ErrorMsg varchar(max);

	IF ([CRS].[ValidateUser](@CURRENT_USER, @CURRENT_REGISTRY_ID) = 0)
	BEGIN
		SET @ErrorMsg = ''User is not authorized to perform this action.'';
		EXEC [CRS].[InsDBLog] @CURRENT_REGISTRY_ID, 0, ''CRS.usp_PATSUB_SECONDARYELIGIBILITY_getitemsByReferral'', @ErrorMsg, ''User is not part of this Registry'', @CURRENT_USER
		SELECT @ErrorMsg as [ErrorMsg];
		RETURN
	END

	SELECT
		[CRS].[PATSUB_SECONDARYELIGIBILITY].*
	FROM 
		[CRS].[REFERRAL]
			INNER JOIN [CRS].[STD_REGISTRY] ON [CRS].[STD_REGISTRY].[ID] = [CRS].[REFERRAL].[STD_REGISTRY_ID]
			INNER JOIN [CRS].[PATIENT] ON [CRS].[PATIENT].[Patient_ID] = [CRS].[REFERRAL].[PATIENT_ID]
			INNER JOIN [CRS].[sPATIENT] ON [CRS].[sPATIENT].[PatientICN] = [CRS].[PATIENT].[PatientICN]
			INNER JOIN [CRS].[PATSUB_SECONDARYELIGIBILITY] ON [CRS].[PATSUB_SECONDARYELIGIBILITY].[PATIENTSID] = [CRS].[sPATIENT].[PatientSID]
	WHERE 
		[CRS].[REFERRAL].[REFERRAL_ID] = @REFERRAL_ID
		AND [CRS].[STD_REGISTRY].[INACTIVE_FLAG] = 0;
END






' 
END
GO

/****** Object:  StoredProcedure [CRS].[usp_PATSUB_VARATEDDISABILITY_getitemsByReferral]    Script Date: 12/8/2017 10:07:52 AM ******/
SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[CRS].[usp_PATSUB_VARATEDDISABILITY_getitemsByReferral]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'

-- =============================================
-- Author:        
-- Create date:   12/6/2017
-- Description:   Get all PATSUB_VARATEDDISABILITY records by Referral
-- =============================================
CREATE PROCEDURE [CRS].[usp_PATSUB_VARATEDDISABILITY_getitemsByReferral] (@CURRENT_USER varchar(30), @CURRENT_REGISTRY_ID int, @REFERRAL_ID int)
AS
BEGIN
	-- SET NOCOUNT ON added to prevent extra result sets from
	-- interfering with SELECT statements.
	SET NOCOUNT ON;

	DECLARE @ErrorMsg varchar(max);

	IF ([CRS].[ValidateUser](@CURRENT_USER, @CURRENT_REGISTRY_ID) = 0)
	BEGIN
		SET @ErrorMsg = ''User is not authorized to perform this action.'';
		EXEC [CRS].[InsDBLog] @CURRENT_REGISTRY_ID, 0, ''CRS.usp_PATSUB_VARATEDDISABILITY_getitemsByReferral'', @ErrorMsg, ''User is not part of this Registry'', @CURRENT_USER
		SELECT @ErrorMsg as [ErrorMsg];
		RETURN
	END

	SELECT
		[CRS].[PATSUB_VARATEDDISABILITY].*
	FROM 
		[CRS].[REFERRAL]
			INNER JOIN [CRS].[STD_REGISTRY] ON [CRS].[STD_REGISTRY].[ID] = [CRS].[REFERRAL].[STD_REGISTRY_ID]
			INNER JOIN [CRS].[PATIENT] ON [CRS].[PATIENT].[Patient_ID] = [CRS].[REFERRAL].[PATIENT_ID]
			INNER JOIN [CRS].[sPATIENT] ON [CRS].[sPATIENT].[PatientICN] = [CRS].[PATIENT].[PatientICN]
			INNER JOIN [CRS].[PATSUB_VARATEDDISABILITY] ON [CRS].[PATSUB_VARATEDDISABILITY].[PatientSID] = [CRS].[sPATIENT].[PatientSID]
	WHERE 
		[CRS].[REFERRAL].[REFERRAL_ID] = @REFERRAL_ID
		AND [CRS].[STD_REGISTRY].[INACTIVE_FLAG] = 0;
END






' 
END
GO

/****** Object:  StoredProcedure [CRS].[usp_PHARMACY_PATIENT_getitemsByReferral]    Script Date: 12/8/2017 10:07:52 AM ******/
SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[CRS].[usp_PHARMACY_PATIENT_getitemsByReferral]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'

-- =============================================
-- Author:        
-- Create date:   12/6/2017
-- Description:   Get all PHARMACY_PATIENT records by Referral
-- =============================================
CREATE PROCEDURE [CRS].[usp_PHARMACY_PATIENT_getitemsByReferral] (@CURRENT_USER varchar(30), @CURRENT_REGISTRY_ID int, @REFERRAL_ID int)
AS
BEGIN
	-- SET NOCOUNT ON added to prevent extra result sets from
	-- interfering with SELECT statements.
	SET NOCOUNT ON;

	DECLARE @ErrorMsg varchar(max);

	IF ([CRS].[ValidateUser](@CURRENT_USER, @CURRENT_REGISTRY_ID) = 0)
	BEGIN
		SET @ErrorMsg = ''User is not authorized to perform this action.'';
		EXEC [CRS].[InsDBLog] @CURRENT_REGISTRY_ID, 0, ''CRS.usp_PHARMACY_PATIENT_getitemsByReferral'', @ErrorMsg, ''User is not part of this Registry'', @CURRENT_USER
		SELECT @ErrorMsg as [ErrorMsg];
		RETURN
	END

	SELECT
		[CRS].[PHARMACY_PATIENT].*
	FROM 
		[CRS].[REFERRAL]
			INNER JOIN [CRS].[STD_REGISTRY] ON [CRS].[STD_REGISTRY].[ID] = [CRS].[REFERRAL].[STD_REGISTRY_ID]
			INNER JOIN [CRS].[PATIENT] ON [CRS].[PATIENT].[Patient_ID] = [CRS].[REFERRAL].[PATIENT_ID]
			INNER JOIN [CRS].[sPATIENT] ON [CRS].[sPATIENT].[PatientICN] = [CRS].[PATIENT].[PatientICN]
			INNER JOIN [CRS].[PHARMACY_PATIENT] ON [CRS].[PHARMACY_PATIENT].[PatientSID] = [CRS].[sPATIENT].[PatientSID]
	WHERE 
		[CRS].[REFERRAL].[REFERRAL_ID] = @REFERRAL_ID
		AND [CRS].[STD_REGISTRY].[INACTIVE_FLAG] = 0;
END







' 
END
GO

/****** Object:  StoredProcedure [CRS].[usp_RADIOLOGYEXAM_getitemsByReferral]    Script Date: 12/8/2017 10:07:52 AM ******/
SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[CRS].[usp_RADIOLOGYEXAM_getitemsByReferral]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'

-- =============================================
-- Author:        
-- Create date:   12/6/2017
-- Description:   Get all RADIOLOGYEXAM records by Referral
-- =============================================
CREATE PROCEDURE [CRS].[usp_RADIOLOGYEXAM_getitemsByReferral] (@CURRENT_USER varchar(30), @CURRENT_REGISTRY_ID int, @REFERRAL_ID int)
AS
BEGIN
	-- SET NOCOUNT ON added to prevent extra result sets from
	-- interfering with SELECT statements.
	SET NOCOUNT ON;

	DECLARE @ErrorMsg varchar(max);

	IF ([CRS].[ValidateUser](@CURRENT_USER, @CURRENT_REGISTRY_ID) = 0)
	BEGIN
		SET @ErrorMsg = ''User is not authorized to perform this action.'';
		EXEC [CRS].[InsDBLog] @CURRENT_REGISTRY_ID, 0, ''CRS.usp_RADIOLOGYEXAM_getitemsByReferral'', @ErrorMsg, ''User is not part of this Registry'', @CURRENT_USER
		SELECT @ErrorMsg as [ErrorMsg];
		RETURN
	END

	SELECT
		[CRS].[RADIOLOGYEXAM].*
	FROM 
		[CRS].[REFERRAL]
			INNER JOIN [CRS].[STD_REGISTRY] ON [CRS].[STD_REGISTRY].[ID] = [CRS].[REFERRAL].[STD_REGISTRY_ID]
			INNER JOIN [CRS].[PATIENT] ON [CRS].[PATIENT].[Patient_ID] = [CRS].[REFERRAL].[PATIENT_ID]
			INNER JOIN [CRS].[sPATIENT] ON [CRS].[sPATIENT].[PatientICN] = [CRS].[PATIENT].[PatientICN]
			INNER JOIN [CRS].[RADIOLOGYEXAM] ON [CRS].[RADIOLOGYEXAM].[PatientSID] = [CRS].[sPATIENT].[PatientSID]
	WHERE 
		[CRS].[REFERRAL].[REFERRAL_ID] = @REFERRAL_ID
		AND [CRS].[STD_REGISTRY].[INACTIVE_FLAG] = 0;
END







' 
END
GO

/****** Object:  StoredProcedure [CRS].[usp_RXOUTPAT_getitemsByReferral]    Script Date: 12/8/2017 10:07:52 AM ******/
SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[CRS].[usp_RXOUTPAT_getitemsByReferral]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'

-- =============================================
-- Author:        
-- Create date:   12/6/2017
-- Description:   Get all RXOUTPAT records by Referral
-- =============================================
CREATE PROCEDURE [CRS].[usp_RXOUTPAT_getitemsByReferral] (@CURRENT_USER varchar(30), @CURRENT_REGISTRY_ID int, @REFERRAL_ID int)
AS
BEGIN
	-- SET NOCOUNT ON added to prevent extra result sets from
	-- interfering with SELECT statements.
	SET NOCOUNT ON;

	DECLARE @ErrorMsg varchar(max);

	IF ([CRS].[ValidateUser](@CURRENT_USER, @CURRENT_REGISTRY_ID) = 0)
	BEGIN
		SET @ErrorMsg = ''User is not authorized to perform this action.'';
		EXEC [CRS].[InsDBLog] @CURRENT_REGISTRY_ID, 0, ''CRS.usp_RXOUTPAT_getitemsByReferral'', @ErrorMsg, ''User is not part of this Registry'', @CURRENT_USER
		SELECT @ErrorMsg as [ErrorMsg];
		RETURN
	END

	SELECT
		[CRS].[RXOUTPAT].*
	FROM 
		[CRS].[REFERRAL]
			INNER JOIN [CRS].[STD_REGISTRY] ON [CRS].[STD_REGISTRY].[ID] = [CRS].[REFERRAL].[STD_REGISTRY_ID]
			INNER JOIN [CRS].[PATIENT] ON [CRS].[PATIENT].[Patient_ID] = [CRS].[REFERRAL].[PATIENT_ID]
			INNER JOIN [CRS].[sPATIENT] ON [CRS].[sPATIENT].[PatientICN] = [CRS].[PATIENT].[PatientICN]
			INNER JOIN [CRS].[RXOUTPAT] ON [CRS].[RXOUTPAT].[PatientSID] = [CRS].[sPATIENT].[PatientSID]
	WHERE 
		[CRS].[REFERRAL].[REFERRAL_ID] = @REFERRAL_ID
		AND [CRS].[STD_REGISTRY].[INACTIVE_FLAG] = 0;
END











' 
END
GO

/****** Object:  StoredProcedure [CRS].[usp_SCONSULT_REASON_getitemsByReferral]    Script Date: 12/8/2017 10:07:52 AM ******/
SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[CRS].[usp_SCONSULT_REASON_getitemsByReferral]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'



-- =============================================
-- Author:        
-- Create date:   12/6/2017
-- Description:   Get all SCONSULT_REASON records by Referral
-- =============================================
CREATE PROCEDURE [CRS].[usp_SCONSULT_REASON_getitemsByReferral] (@CURRENT_USER varchar(30), @CURRENT_REGISTRY_ID int, @REFERRAL_ID int)
AS
BEGIN
	-- SET NOCOUNT ON added to prevent extra result sets from
	-- interfering with SELECT statements.
	SET NOCOUNT ON;

	DECLARE @ErrorMsg varchar(max);

	IF ([CRS].[ValidateUser](@CURRENT_USER, @CURRENT_REGISTRY_ID) = 0)
	BEGIN
		SET @ErrorMsg = ''User is not authorized to perform this action.'';
		EXEC [CRS].[InsDBLog] @CURRENT_REGISTRY_ID, 0, ''CRS.usp_SCONSULT_REASON_getitemsByReferral'', @ErrorMsg, ''User is not part of this Registry'', @CURRENT_USER
		SELECT @ErrorMsg as [ErrorMsg];
		RETURN
	END

	SELECT
		[CRS].[SCONSULT_REASON].*
	FROM 
		[CRS].[REFERRAL]
			INNER JOIN [CRS].[STD_REGISTRY] ON [CRS].[STD_REGISTRY].[ID] = [CRS].[REFERRAL].[STD_REGISTRY_ID]
			INNER JOIN [CRS].[PATIENT] ON [CRS].[PATIENT].[Patient_ID] = [CRS].[REFERRAL].[PATIENT_ID]
			INNER JOIN [CRS].[sPATIENT] ON [CRS].[sPATIENT].[PatientICN] = [CRS].[PATIENT].[PatientICN]
			INNER JOIN [CRS].[SCONSULT_REASON] ON [CRS].[SCONSULT_REASON].[PATIENTSID] = [CRS].[sPATIENT].[PatientSID]
	WHERE 
		[CRS].[REFERRAL].[REFERRAL_ID] = @REFERRAL_ID
		AND [CRS].[STD_REGISTRY].[INACTIVE_FLAG] = 0;
END












' 
END
GO

/****** Object:  StoredProcedure [CRS].[usp_SERVICE_CONNECTED_CONDITION_getitemsByReferral]    Script Date: 12/8/2017 10:07:52 AM ******/
SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[CRS].[usp_SERVICE_CONNECTED_CONDITION_getitemsByReferral]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'

-- =============================================
-- Author:        
-- Create date:   12/6/2017
-- Description:   Get all SERVICE_CONNECTED_CONDITION records by Referral
-- =============================================
CREATE PROCEDURE [CRS].[usp_SERVICE_CONNECTED_CONDITION_getitemsByReferral] (@CURRENT_USER varchar(30), @CURRENT_REGISTRY_ID int, @REFERRAL_ID int)
AS
BEGIN
	-- SET NOCOUNT ON added to prevent extra result sets from
	-- interfering with SELECT statements.
	SET NOCOUNT ON;

	DECLARE @ErrorMsg varchar(max);

	IF ([CRS].[ValidateUser](@CURRENT_USER, @CURRENT_REGISTRY_ID) = 0)
	BEGIN
		SET @ErrorMsg = ''User is not authorized to perform this action.'';
		EXEC [CRS].[InsDBLog] @CURRENT_REGISTRY_ID, 0, ''CRS.usp_SERVICE_CONNECTED_CONDITION_getitemsByReferral'', @ErrorMsg, ''User is not part of this Registry'', @CURRENT_USER
		SELECT @ErrorMsg as [ErrorMsg];
		RETURN
	END

	SELECT
		[CRS].[SERVICE_CONNECTED_CONDITION].*
	FROM 
		[CRS].[REFERRAL]
			INNER JOIN [CRS].[STD_REGISTRY] ON [CRS].[STD_REGISTRY].[ID] = [CRS].[REFERRAL].[STD_REGISTRY_ID]
			INNER JOIN [CRS].[PATIENT] ON [CRS].[PATIENT].[Patient_ID] = [CRS].[REFERRAL].[PATIENT_ID]
			INNER JOIN [CRS].[sPATIENT] ON [CRS].[sPATIENT].[PatientICN] = [CRS].[PATIENT].[PatientICN]
			INNER JOIN [CRS].[SERVICE_CONNECTED_CONDITION] ON [CRS].[SERVICE_CONNECTED_CONDITION].[PatientSID] = [CRS].[sPATIENT].[PatientSID]
	WHERE 
		[CRS].[REFERRAL].[REFERRAL_ID] = @REFERRAL_ID
		AND [CRS].[STD_REGISTRY].[INACTIVE_FLAG] = 0;
END




' 
END
GO

/****** Object:  StoredProcedure [CRS].[usp_SPATIENT_NEW_getitemsByReferral]    Script Date: 12/8/2017 10:07:52 AM ******/
SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[CRS].[usp_SPATIENT_NEW_getitemsByReferral]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'

-- =============================================
-- Author:        
-- Create date:   12/6/2017
-- Description:   Get all SPATIENT_NEW records by Referral
-- =============================================
CREATE PROCEDURE [CRS].[usp_SPATIENT_NEW_getitemsByReferral] (@CURRENT_USER varchar(30), @CURRENT_REGISTRY_ID int, @REFERRAL_ID int)
AS
BEGIN
	-- SET NOCOUNT ON added to prevent extra result sets from
	-- interfering with SELECT statements.
	SET NOCOUNT ON;

	DECLARE @ErrorMsg varchar(max);

	IF ([CRS].[ValidateUser](@CURRENT_USER, @CURRENT_REGISTRY_ID) = 0)
	BEGIN
		SET @ErrorMsg = ''User is not authorized to perform this action.'';
		EXEC [CRS].[InsDBLog] @CURRENT_REGISTRY_ID, 0, ''CRS.usp_SPATIENT_NEW_getitemsByReferral'', @ErrorMsg, ''User is not part of this Registry'', @CURRENT_USER
		SELECT @ErrorMsg as [ErrorMsg];
		RETURN
	END

	SELECT
		[CRS].[SPATIENT_NEW].*
	FROM 
		[CRS].[REFERRAL]
			INNER JOIN [CRS].[STD_REGISTRY] ON [CRS].[STD_REGISTRY].[ID] = [CRS].[REFERRAL].[STD_REGISTRY_ID]
			INNER JOIN [CRS].[PATIENT] ON [CRS].[PATIENT].[Patient_ID] = [CRS].[REFERRAL].[PATIENT_ID]
			INNER JOIN [CRS].[sPATIENT] ON [CRS].[sPATIENT].[PatientICN] = [CRS].[PATIENT].[PatientICN]
			INNER JOIN [CRS].[SPATIENT_NEW] ON [CRS].[SPATIENT_NEW].[PatientSID] = [CRS].[sPATIENT].[PatientSID]
	WHERE 
		[CRS].[REFERRAL].[REFERRAL_ID] = @REFERRAL_ID
		AND [CRS].[STD_REGISTRY].[INACTIVE_FLAG] = 0;
END








' 
END
GO

/****** Object:  StoredProcedure [CRS].[usp_SPATIENT_SPATIENTINSURANCE_getitemsByReferral]    Script Date: 12/8/2017 10:07:52 AM ******/
SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[CRS].[usp_SPATIENT_SPATIENTINSURANCE_getitemsByReferral]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'

-- =============================================
-- Author:        
-- Create date:   12/6/2017
-- Description:   Get all SPATIENT_SPATIENTINSURANCE records by Referral
-- =============================================
CREATE PROCEDURE [CRS].[usp_SPATIENT_SPATIENTINSURANCE_getitemsByReferral] (@CURRENT_USER varchar(30), @CURRENT_REGISTRY_ID int, @REFERRAL_ID int)
AS
BEGIN
	-- SET NOCOUNT ON added to prevent extra result sets from
	-- interfering with SELECT statements.
	SET NOCOUNT ON;

	DECLARE @ErrorMsg varchar(max);

	IF ([CRS].[ValidateUser](@CURRENT_USER, @CURRENT_REGISTRY_ID) = 0)
	BEGIN
		SET @ErrorMsg = ''User is not authorized to perform this action.'';
		EXEC [CRS].[InsDBLog] @CURRENT_REGISTRY_ID, 0, ''CRS.usp_SPATIENT_SPATIENTINSURANCE_getitemsByReferral'', @ErrorMsg, ''User is not part of this Registry'', @CURRENT_USER
		SELECT @ErrorMsg as [ErrorMsg];
		RETURN
	END

	SELECT
		[CRS].[SPATIENT_SPATIENTINSURANCE].*
	FROM 
		[CRS].[REFERRAL]
			INNER JOIN [CRS].[STD_REGISTRY] ON [CRS].[STD_REGISTRY].[ID] = [CRS].[REFERRAL].[STD_REGISTRY_ID]
			INNER JOIN [CRS].[PATIENT] ON [CRS].[PATIENT].[Patient_ID] = [CRS].[REFERRAL].[PATIENT_ID]
			INNER JOIN [CRS].[sPATIENT] ON [CRS].[sPATIENT].[PatientICN] = [CRS].[PATIENT].[PatientICN]
			INNER JOIN [CRS].[SPATIENT_SPATIENTINSURANCE] ON [CRS].[SPATIENT_SPATIENTINSURANCE].[PatientSID] = [CRS].[sPATIENT].[PatientSID]
	WHERE 
		[CRS].[REFERRAL].[REFERRAL_ID] = @REFERRAL_ID
		AND [CRS].[STD_REGISTRY].[INACTIVE_FLAG] = 0;
END






' 
END
GO

/****** Object:  StoredProcedure [CRS].[usp_TIU_TIUDOCUMENT_getitemsByReferral]    Script Date: 12/8/2017 10:07:52 AM ******/
SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[CRS].[usp_TIU_TIUDOCUMENT_getitemsByReferral]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'

-- =============================================
-- Author:        
-- Create date:   12/6/2017
-- Description:   Get all TIU_TIUDOCUMENT records by Referral
-- =============================================
CREATE PROCEDURE [CRS].[usp_TIU_TIUDOCUMENT_getitemsByReferral] (@CURRENT_USER varchar(30), @CURRENT_REGISTRY_ID int, @REFERRAL_ID int)
AS
BEGIN
	-- SET NOCOUNT ON added to prevent extra result sets from
	-- interfering with SELECT statements.
	SET NOCOUNT ON;

	DECLARE @ErrorMsg varchar(max);

	IF ([CRS].[ValidateUser](@CURRENT_USER, @CURRENT_REGISTRY_ID) = 0)
	BEGIN
		SET @ErrorMsg = ''User is not authorized to perform this action.'';
		EXEC [CRS].[InsDBLog] @CURRENT_REGISTRY_ID, 0, ''CRS.usp_TIU_TIUDOCUMENT_getitemsByReferral'', @ErrorMsg, ''User is not part of this Registry'', @CURRENT_USER
		SELECT @ErrorMsg as [ErrorMsg];
		RETURN
	END

	SELECT
		[CRS].[TIU_TIUDOCUMENT].*
	FROM 
		[CRS].[REFERRAL]
			INNER JOIN [CRS].[STD_REGISTRY] ON [CRS].[STD_REGISTRY].[ID] = [CRS].[REFERRAL].[STD_REGISTRY_ID]
			INNER JOIN [CRS].[PATIENT] ON [CRS].[PATIENT].[Patient_ID] = [CRS].[REFERRAL].[PATIENT_ID]
			INNER JOIN [CRS].[sPATIENT] ON [CRS].[sPATIENT].[PatientICN] = [CRS].[PATIENT].[PatientICN]
			INNER JOIN [CRS].[TIU_TIUDOCUMENT] ON [CRS].[TIU_TIUDOCUMENT].[PatientSID] = [CRS].[sPATIENT].[PatientSID]
	WHERE 
		[CRS].[REFERRAL].[REFERRAL_ID] = @REFERRAL_ID
		AND [CRS].[STD_REGISTRY].[INACTIVE_FLAG] = 0;
END






' 
END
GO

/****** Object:  StoredProcedure [CRS].[usp_VITALSIGN_getitemsByReferral]    Script Date: 12/8/2017 10:07:52 AM ******/
SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[CRS].[usp_VITALSIGN_getitemsByReferral]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'

-- =============================================
-- Author:        
-- Create date:   12/6/2017
-- Description:   Get all VITALSIGN records by Referral
-- =============================================
CREATE PROCEDURE [CRS].[usp_VITALSIGN_getitemsByReferral] (@CURRENT_USER varchar(30), @CURRENT_REGISTRY_ID int, @REFERRAL_ID int)
AS
BEGIN
	-- SET NOCOUNT ON added to prevent extra result sets from
	-- interfering with SELECT statements.
	SET NOCOUNT ON;

	DECLARE @ErrorMsg varchar(max);

	IF ([CRS].[ValidateUser](@CURRENT_USER, @CURRENT_REGISTRY_ID) = 0)
	BEGIN
		SET @ErrorMsg = ''User is not authorized to perform this action.'';
		EXEC [CRS].[InsDBLog] @CURRENT_REGISTRY_ID, 0, ''CRS.usp_VITALSIGN_getitemsByReferral'', @ErrorMsg, ''User is not part of this Registry'', @CURRENT_USER
		SELECT @ErrorMsg as [ErrorMsg];
		RETURN
	END

	SELECT
		[CRS].[VITALSIGN].*
	FROM 
		[CRS].[REFERRAL]
			INNER JOIN [CRS].[STD_REGISTRY] ON [CRS].[STD_REGISTRY].[ID] = [CRS].[REFERRAL].[STD_REGISTRY_ID]
			INNER JOIN [CRS].[PATIENT] ON [CRS].[PATIENT].[Patient_ID] = [CRS].[REFERRAL].[PATIENT_ID]
			INNER JOIN [CRS].[sPATIENT] ON [CRS].[sPATIENT].[PatientICN] = [CRS].[PATIENT].[PatientICN]
			INNER JOIN [CRS].[VITALSIGN] ON [CRS].[VITALSIGN].[PatientSID] = [CRS].[sPATIENT].[PatientSID]
	WHERE 
		[CRS].[REFERRAL].[REFERRAL_ID] = @REFERRAL_ID
		AND [CRS].[STD_REGISTRY].[INACTIVE_FLAG] = 0;
END' 

END
GO




/****** Object:  StoredProcedure [CRS].[usp_REGISTRY_FRAMEWORK_DATA_getitemsByRegistry]    Script Date: 12/8/2017 9:48:02 AM ******/
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[CRS].[usp_REGISTRY_FRAMEWORK_DATA_getitemsByRegistry]') AND type in (N'P', N'PC'))
DROP PROCEDURE [CRS].[usp_REGISTRY_FRAMEWORK_DATA_getitemsByRegistry]
GO

/****** Object:  StoredProcedure [CRS].[usp_REGISTRY_FRAMEWORK_DATA_getitemsByRegistry]    Script Date: 12/8/2017 9:48:02 AM ******/
SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[CRS].[usp_REGISTRY_FRAMEWORK_DATA_getitemsByRegistry]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'

-- =============================================
-- Author:        
-- Create date:   03/16/2016
-- Description:   Get all records
-- =============================================
CREATE PROCEDURE [CRS].[usp_REGISTRY_FRAMEWORK_DATA_getitemsByRegistry] (@CURRENT_USER varchar(30), @CURRENT_REGISTRY_ID int)
AS
BEGIN
	-- SET NOCOUNT ON added to prevent extra result sets from
	-- interfering with SELECT statements.
	SET NOCOUNT ON;

	DECLARE @ErrorMsg varchar(max);

	IF ([CRS].[ValidateUser](@CURRENT_USER, @CURRENT_REGISTRY_ID) = 0)
	BEGIN
		SET @ErrorMsg = ''User is not authorized to perform this action.'';
		EXEC [CRS].[InsDBLog] @CURRENT_REGISTRY_ID, 0, ''CRS.[usp_REGISTRY_FRAMEWORK_DATA_getitemsByRegistry]'', @ErrorMsg, ''User is not part of an Admin Role'', @CURRENT_USER
		SELECT @ErrorMsg as [ErrorMsg];
		RETURN
	END
	SELECT DISTINCT [Name],[Value] FROM
	(SELECT DISTINCT DESCRIPTION_TEXT AS [Name], '''' AS Value FROM [CRS].[STD_REGISTRY_CORE_TYPES]
	WHERE CORE_TYPE_ID IN (SELECT CORE_TYPE_ID FROM CRS.REGISTRY_CORE_DATA WHERE STD_REGISTRY_ID = @CURRENT_REGISTRY_ID AND SELECTED_FLAG=1)) AS RSLT
	GROUP BY [Name],[Value]
	
END' 

END
GO

---------------------------------------------------------------------------------------------------------------------------------
--Work Item 618267 Sync Settings and/or application config files
---------------------------------------------------------------------------------------------------------------------------------

/****** Object:  StoredProcedure [CRS].[usp_SETTINGS_getitems]    Script Date: 12/8/2017 9:45:01 AM ******/
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[CRS].[usp_SETTINGS_getitems]') AND type in (N'P', N'PC'))
DROP PROCEDURE [CRS].[usp_SETTINGS_getitems]
GO

/****** Object:  StoredProcedure [CRS].[usp_SETTINGS_getitems]    Script Date: 12/8/2017 9:45:01 AM ******/
SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[CRS].[usp_SETTINGS_getitems]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'

-- =============================================
-- Author:        
-- Create date:   03/17/2016
-- Description:   Get all records
-- =============================================
CREATE PROCEDURE [CRS].[usp_SETTINGS_getitems]
AS
BEGIN
	-- SET NOCOUNT ON added to prevent extra result sets from
	-- interfering with SELECT statements.
	SET NOCOUNT ON;

	SELECT * FROM [CRS].[SETTINGS] where STD_REGISTRY_ID = 1;
END' 

END
GO

---------------------------------------------------------------------------------------------------------------------------------
--Reset default criteria
---------------------------------------------------------------------------------------------------------------------------------

update CRS.STD_REGISTRY_CORE_TYPES set DEFAULT_FLAG=1;

update CRS.STD_REGISTRY_COHORT_TYPES set DEFAULT_FLAG=1;

update CRS.STD_REGISTRY_COHORT_TYPES set DEFAULT_FLAG=0
where description_text in ('CPTCodes for a patient','ICD9_Code','ICD10_Code');

update CRS.STD_REGISTRY_COHORT_TYPES set DEFAULT_FLAG=1 where DESCRIPTION_TEXT='ICD10_Code' 
and CODE in ('C80.2','D47.Z1','I25.811','I25.812','T86.00','T86.10','T86.20','T86.40','T86.810','T86.850','T86.890','T86.90','Y83.0','Z48.298','Z94.0','Z94.1','Z94.2','Z94.4','Z94.81','Z94.82','Z94.83','Z94.84','Z94.89','Z98.85');